/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.DeviceContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Device;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlDeviceReader {
    public static Device readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        DeviceContainer object = new DeviceContainer();
        block28: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block28;
                }
                case "id": {
                    object.id(image);
                    continue block28;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block29: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block29;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block29;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block29;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block29;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block29;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block29;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block29;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block29;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlDeviceReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Device> iterateMany(final XmlReader reader) {
        return new Iterator<Device>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Device next() {
                Device next = XmlDeviceReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Device> readMany(XmlReader reader) {
        ArrayList<Device> list = new ArrayList<Device>();
        Iterator<Device> iterator = XmlDeviceReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(DeviceContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

