/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.IscsiBondContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionReader;
import org.ovirt.engine.sdk4.types.IscsiBond;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class XmlIscsiBondReader {
    public static IscsiBond readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        IscsiBondContainer object = new IscsiBondContainer();
        block26: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block26;
                }
                case "id": {
                    object.id(image);
                    continue block26;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block27: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block27;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block27;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block27;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block27;
                }
                case "networks": {
                    object.networks(XmlNetworkReader.readMany(reader));
                    continue block27;
                }
                case "storage_connections": {
                    object.storageConnections(XmlStorageConnectionReader.readMany(reader));
                    continue block27;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block27;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlIscsiBondReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<IscsiBond> iterateMany(final XmlReader reader) {
        return new Iterator<IscsiBond>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public IscsiBond next() {
                IscsiBond next = XmlIscsiBondReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<IscsiBond> readMany(XmlReader reader) {
        ArrayList<IscsiBond> list = new ArrayList<IscsiBond>();
        Iterator<IscsiBond> iterator = XmlIscsiBondReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(IscsiBondContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "networks": {
                    ArrayListWithHref<Network> list = new ArrayListWithHref<Network>(object.networks());
                    list.href(href);
                    object.networks(list);
                    break;
                }
                case "storageconnections": {
                    ArrayListWithHref<StorageConnection> list = new ArrayListWithHref<StorageConnection>(object.storageConnections());
                    list.href(href);
                    object.storageConnections(list);
                    break;
                }
            }
        }
    }
}

