/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.MigrationPolicyContainer;
import org.ovirt.engine.sdk4.types.MigrationPolicy;

public class XmlMigrationPolicyReader {
    public static MigrationPolicy readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        MigrationPolicyContainer object = new MigrationPolicyContainer();
        block20: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block20;
                }
                case "id": {
                    object.id(image);
                    continue block20;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block21: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block21;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block21;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block21;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block21;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlMigrationPolicyReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<MigrationPolicy> iterateMany(final XmlReader reader) {
        return new Iterator<MigrationPolicy>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public MigrationPolicy next() {
                MigrationPolicy next = XmlMigrationPolicyReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<MigrationPolicy> readMany(XmlReader reader) {
        ArrayList<MigrationPolicy> list = new ArrayList<MigrationPolicy>();
        Iterator<MigrationPolicy> iterator = XmlMigrationPolicyReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(MigrationPolicyContainer object, String[] link) {
    }
}

