/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.QuotaContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaClusterLimitReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaStorageLimitReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaClusterLimit;
import org.ovirt.engine.sdk4.types.QuotaStorageLimit;

public class XmlQuotaReader {
    public static Quota readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        QuotaContainer object = new QuotaContainer();
        block42: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block42;
                }
                case "id": {
                    object.id(image);
                    continue block42;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block43: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "cluster_hard_limit_pct": {
                    object.clusterHardLimitPct(reader.readInteger());
                    continue block43;
                }
                case "cluster_soft_limit_pct": {
                    object.clusterSoftLimitPct(reader.readInteger());
                    continue block43;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block43;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block43;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block43;
                }
                case "disks": {
                    object.disks(XmlDiskReader.readMany(reader));
                    continue block43;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block43;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block43;
                }
                case "quota_cluster_limits": {
                    object.quotaClusterLimits(XmlQuotaClusterLimitReader.readMany(reader));
                    continue block43;
                }
                case "quota_storage_limits": {
                    object.quotaStorageLimits(XmlQuotaStorageLimitReader.readMany(reader));
                    continue block43;
                }
                case "storage_hard_limit_pct": {
                    object.storageHardLimitPct(reader.readInteger());
                    continue block43;
                }
                case "storage_soft_limit_pct": {
                    object.storageSoftLimitPct(reader.readInteger());
                    continue block43;
                }
                case "users": {
                    object.users(XmlUserReader.readMany(reader));
                    continue block43;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block43;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block43;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlQuotaReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Quota> iterateMany(final XmlReader reader) {
        return new Iterator<Quota>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Quota next() {
                Quota next = XmlQuotaReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Quota> readMany(XmlReader reader) {
        ArrayList<Quota> list = new ArrayList<Quota>();
        Iterator<Quota> iterator = XmlQuotaReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(QuotaContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "quotaclusterlimits": {
                    ArrayListWithHref<QuotaClusterLimit> list = new ArrayListWithHref<QuotaClusterLimit>(object.quotaClusterLimits());
                    list.href(href);
                    object.quotaClusterLimits(list);
                    break;
                }
                case "quotastoragelimits": {
                    ArrayListWithHref<QuotaStorageLimit> list = new ArrayListWithHref<QuotaStorageLimit>(object.quotaStorageLimits());
                    list.href(href);
                    object.quotaStorageLimits(list);
                    break;
                }
            }
        }
    }
}

