/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.RoleContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlPermitReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.types.Permit;
import org.ovirt.engine.sdk4.types.Role;

public class XmlRoleReader {
    public static Role readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        RoleContainer object = new RoleContainer();
        block28: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block28;
                }
                case "id": {
                    object.id(image);
                    continue block28;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block29: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "administrative": {
                    object.administrative(reader.readBoolean());
                    continue block29;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block29;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block29;
                }
                case "mutable": {
                    object.mutable(reader.readBoolean());
                    continue block29;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block29;
                }
                case "permits": {
                    object.permits(XmlPermitReader.readMany(reader));
                    continue block29;
                }
                case "user": {
                    object.user(XmlUserReader.readOne(reader));
                    continue block29;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block29;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlRoleReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Role> iterateMany(final XmlReader reader) {
        return new Iterator<Role>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Role next() {
                Role next = XmlRoleReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Role> readMany(XmlReader reader) {
        ArrayList<Role> list = new ArrayList<Role>();
        Iterator<Role> iterator = XmlRoleReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(RoleContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "permits": {
                    ArrayListWithHref<Permit> list = new ArrayListWithHref<Permit>(object.permits());
                    list.href(href);
                    object.permits(list);
                    break;
                }
            }
        }
    }
}

