/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.PermitBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.containers.RoleContainer;
import org.ovirt.engine.sdk4.types.Permit;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.User;

public class RoleBuilder {
    private Boolean administrative;
    private String comment;
    private String description;
    private String href;
    private String id;
    private Boolean mutable;
    private String name;
    private List<Permit> permits;
    private User user;

    public RoleBuilder administrative(boolean newAdministrative) {
        this.administrative = newAdministrative;
        return this;
    }

    public RoleBuilder administrative(Boolean newAdministrative) {
        this.administrative = newAdministrative;
        return this;
    }

    public RoleBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public RoleBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public RoleBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public RoleBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public RoleBuilder mutable(boolean newMutable) {
        this.mutable = newMutable;
        return this;
    }

    public RoleBuilder mutable(Boolean newMutable) {
        this.mutable = newMutable;
        return this;
    }

    public RoleBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public RoleBuilder permits(List<Permit> newPermits) {
        if (newPermits != null) {
            if (this.permits == null) {
                this.permits = new ArrayList<Permit>(newPermits);
            } else {
                this.permits.addAll(newPermits);
            }
        }
        return this;
    }

    public RoleBuilder permits(Permit ... newPermits) {
        if (newPermits != null) {
            if (this.permits == null) {
                this.permits = new ArrayList<Permit>(newPermits.length);
            }
            Collections.addAll(this.permits, newPermits);
        }
        return this;
    }

    public RoleBuilder permits(PermitBuilder ... newPermits) {
        if (newPermits != null) {
            if (this.permits == null) {
                this.permits = new ArrayList<Permit>(newPermits.length);
            }
            for (PermitBuilder builder : newPermits) {
                this.permits.add(builder.build());
            }
        }
        return this;
    }

    public RoleBuilder user(User newUser) {
        this.user = newUser;
        return this;
    }

    public RoleBuilder user(UserBuilder newUser) {
        this.user = newUser == null ? null : newUser.build();
        return this;
    }

    public Role build() {
        RoleContainer container = new RoleContainer();
        container.administrative(this.administrative);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.mutable(this.mutable);
        container.name(this.name);
        container.permits(this.permits);
        container.user(this.user);
        return container;
    }
}

