/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.IpContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlIpVersionReader;
import org.ovirt.engine.sdk4.types.Ip;

public class XmlIpReader {
    public static Ip readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        IpContainer object = new IpContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block14: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block14;
                }
                case "gateway": {
                    object.gateway(reader.readString());
                    continue block14;
                }
                case "netmask": {
                    object.netmask(reader.readString());
                    continue block14;
                }
                case "version": {
                    object.version(XmlIpVersionReader.readOne(reader));
                    continue block14;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block14;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlIpReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Ip> iterateMany(final XmlReader reader) {
        return new Iterator<Ip>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Ip next() {
                Ip next = XmlIpReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Ip> readMany(XmlReader reader) {
        ArrayList<Ip> list = new ArrayList<Ip>();
        Iterator<Ip> iterator = XmlIpReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(IpContainer object, String[] link) {
    }
}

