/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.Date;
import org.ovirt.engine.sdk4.builders.ApiSummaryBuilder;
import org.ovirt.engine.sdk4.builders.ProductInfoBuilder;
import org.ovirt.engine.sdk4.builders.SpecialObjectsBuilder;
import org.ovirt.engine.sdk4.internal.containers.ApiContainer;
import org.ovirt.engine.sdk4.types.Api;
import org.ovirt.engine.sdk4.types.ApiSummary;
import org.ovirt.engine.sdk4.types.ProductInfo;
import org.ovirt.engine.sdk4.types.SpecialObjects;

public class ApiBuilder {
    private ProductInfo productInfo;
    private SpecialObjects specialObjects;
    private ApiSummary summary;
    private Date time;

    public ApiBuilder productInfo(ProductInfo newProductInfo) {
        this.productInfo = newProductInfo;
        return this;
    }

    public ApiBuilder productInfo(ProductInfoBuilder newProductInfo) {
        this.productInfo = newProductInfo == null ? null : newProductInfo.build();
        return this;
    }

    public ApiBuilder specialObjects(SpecialObjects newSpecialObjects) {
        this.specialObjects = newSpecialObjects;
        return this;
    }

    public ApiBuilder specialObjects(SpecialObjectsBuilder newSpecialObjects) {
        this.specialObjects = newSpecialObjects == null ? null : newSpecialObjects.build();
        return this;
    }

    public ApiBuilder summary(ApiSummary newSummary) {
        this.summary = newSummary;
        return this;
    }

    public ApiBuilder summary(ApiSummaryBuilder newSummary) {
        this.summary = newSummary == null ? null : newSummary.build();
        return this;
    }

    public ApiBuilder time(Date newTime) {
        this.time = newTime == null ? null : new Date(newTime.getTime());
        return this;
    }

    public Api build() {
        ApiContainer container = new ApiContainer();
        container.productInfo(this.productInfo);
        container.specialObjects(this.specialObjects);
        container.summary(this.summary);
        container.time(this.time);
        return container;
    }
}

