/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PmProxyType {
    CLUSTER("cluster"),
    DC("dc"),
    OTHER_DC("other_dc");

    private static final Logger log;
    private String image;

    private PmProxyType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static PmProxyType fromValue(String value) {
        try {
            return PmProxyType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'PmProxyType' enumerated type. Valid values are 'cluster', 'dc' and 'other_dc'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(PmProxyType.class);
    }
}

