/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Snapshot;

public interface SnapshotService extends Service {
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        Snapshot snapshot();
    }
    
    GetRequest get();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if all the attributes of the virtual machine snapshot should be included in the response.
         * 
         * By default the attribute `initialization.configuration.data` is excluded.
         * 
         * For example, to retrieve the complete representation of the snapshot with id `456` of the virtual machine
         * with id `123` send a request like this:
         * 
         * ....
         * GET /ovirt-engine/api/vms/123/snapshots/456?all_content=true
         * ....
         */
        RemoveRequest allContent(Boolean allContent);
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    /**
     * Restores a virtual machine snapshot.
     * 
     * For example, to restore the snapshot with identifier `456` of virtual machine with identifier `123` send a
     * request like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/123/snapshots/456/restore
     * ----
     * 
     * With an empty `action` in the body:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface RestoreRequest extends Request<RestoreRequest, RestoreResponse> {
        /**
         * Indicates if the restore should be performed asynchronously.
         */
        RestoreRequest async(Boolean async);
        RestoreRequest disks(List<Disk> disks);
        RestoreRequest disks(Disk... disks);
        RestoreRequest disks(DiskBuilder... disks);
        RestoreRequest restoreMemory(Boolean restoreMemory);
    }
    
    /**
     * Restores a virtual machine snapshot.
     * 
     * For example, to restore the snapshot with identifier `456` of virtual machine with identifier `123` send a
     * request like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/123/snapshots/456/restore
     * ----
     * 
     * With an empty `action` in the body:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface RestoreResponse extends Response {
    }
    
    /**
     * Restores a virtual machine snapshot.
     * 
     * For example, to restore the snapshot with identifier `456` of virtual machine with identifier `123` send a
     * request like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/123/snapshots/456/restore
     * ----
     * 
     * With an empty `action` in the body:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    RestoreRequest restore();
    
    SnapshotCdromsService cdromsService();
    SnapshotDisksService disksService();
    SnapshotNicsService nicsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

