/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.GlusterBrickContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterBrickStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterClientReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterMemoryPoolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterVolumeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.GlusterBrick;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlGlusterBrickReader {
    public static GlusterBrick readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        GlusterBrickContainer object = new GlusterBrickContainer();
        block52: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block52;
                }
                case "id": {
                    object.id(image);
                    continue block52;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block53: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "brick_dir": {
                    object.brickDir(reader.readString());
                    continue block53;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block53;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block53;
                }
                case "device": {
                    object.device(reader.readString());
                    continue block53;
                }
                case "fs_name": {
                    object.fsName(reader.readString());
                    continue block53;
                }
                case "gluster_clients": {
                    object.glusterClients(XmlGlusterClientReader.readMany(reader));
                    continue block53;
                }
                case "gluster_volume": {
                    object.glusterVolume(XmlGlusterVolumeReader.readOne(reader));
                    continue block53;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block53;
                }
                case "memory_pools": {
                    object.memoryPools(XmlGlusterMemoryPoolReader.readMany(reader));
                    continue block53;
                }
                case "mnt_options": {
                    object.mntOptions(reader.readString());
                    continue block53;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block53;
                }
                case "pid": {
                    object.pid(reader.readInteger());
                    continue block53;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block53;
                }
                case "server_id": {
                    object.serverId(reader.readString());
                    continue block53;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block53;
                }
                case "status": {
                    object.status(XmlGlusterBrickStatusReader.readOne(reader));
                    continue block53;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block53;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block53;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block53;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block53;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlGlusterBrickReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<GlusterBrick> iterateMany(final XmlReader reader) {
        return new Iterator<GlusterBrick>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public GlusterBrick next() {
                GlusterBrick next = XmlGlusterBrickReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<GlusterBrick> readMany(XmlReader reader) {
        ArrayList<GlusterBrick> list = new ArrayList<GlusterBrick>();
        Iterator<GlusterBrick> iterator = XmlGlusterBrickReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(GlusterBrickContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

