/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ImageFileType {
    DISK("disk"),
    FLOPPY("floppy"),
    ISO("iso");

    private static final Logger log;
    private String image;

    private ImageFileType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ImageFileType fromValue(String value) {
        try {
            return ImageFileType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ImageFileType' enumerated type. Valid values are 'disk', 'floppy' and 'iso'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ImageFileType.class);
    }
}

