/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.JobContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlJobStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStepReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.types.Job;
import org.ovirt.engine.sdk4.types.Step;

public class XmlJobReader {
    public static Job readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        JobContainer object = new JobContainer();
        block36: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block36;
                }
                case "id": {
                    object.id(image);
                    continue block36;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block37: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "auto_cleared": {
                    object.autoCleared(reader.readBoolean());
                    continue block37;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block37;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block37;
                }
                case "end_time": {
                    object.endTime(reader.readDate());
                    continue block37;
                }
                case "external": {
                    object.external(reader.readBoolean());
                    continue block37;
                }
                case "last_updated": {
                    object.lastUpdated(reader.readDate());
                    continue block37;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block37;
                }
                case "owner": {
                    object.owner(XmlUserReader.readOne(reader));
                    continue block37;
                }
                case "start_time": {
                    object.startTime(reader.readDate());
                    continue block37;
                }
                case "status": {
                    object.status(XmlJobStatusReader.readOne(reader));
                    continue block37;
                }
                case "steps": {
                    object.steps(XmlStepReader.readMany(reader));
                    continue block37;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block37;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlJobReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Job> iterateMany(final XmlReader reader) {
        return new Iterator<Job>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Job next() {
                Job next = XmlJobReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Job> readMany(XmlReader reader) {
        ArrayList<Job> list = new ArrayList<Job>();
        Iterator<Job> iterator = XmlJobReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(JobContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "steps": {
                    ArrayListWithHref<Step> list = new ArrayListWithHref<Step>(object.steps());
                    list.href(href);
                    object.steps(list);
                    break;
                }
            }
        }
    }
}

