/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BackupPhase {
    FINALIZING("finalizing"),
    INITIALIZING("initializing"),
    READY("ready"),
    STARTING("starting");

    private static final Logger log;
    private String image;

    private BackupPhase(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static BackupPhase fromValue(String value) {
        try {
            return BackupPhase.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'BackupPhase' enumerated type. Valid values are 'finalizing', 'initializing', 'ready' and 'starting'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(BackupPhase.class);
    }
}

