/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.Backup;
import org.ovirt.engine.sdk4.types.BackupPhase;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Vm;

public class BackupContainer
extends IdentifiedContainer
implements Backup {
    private Date creationDate;
    private String fromCheckpointId;
    private BackupPhase phase;
    private String toCheckpointId;
    private List<Disk> disks;
    private Vm vm;

    @Override
    public Date creationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return new Date(this.creationDate.getTime());
    }

    public void creationDate(Date newCreationDate) {
        this.creationDate = newCreationDate == null ? null : new Date(newCreationDate.getTime());
    }

    @Override
    public boolean creationDatePresent() {
        return this.creationDate != null;
    }

    @Override
    public String fromCheckpointId() {
        return this.fromCheckpointId;
    }

    public void fromCheckpointId(String newFromCheckpointId) {
        this.fromCheckpointId = newFromCheckpointId;
    }

    @Override
    public boolean fromCheckpointIdPresent() {
        return this.fromCheckpointId != null;
    }

    @Override
    public BackupPhase phase() {
        return this.phase;
    }

    public void phase(BackupPhase newPhase) {
        this.phase = newPhase;
    }

    @Override
    public boolean phasePresent() {
        return this.phase != null;
    }

    @Override
    public String toCheckpointId() {
        return this.toCheckpointId;
    }

    public void toCheckpointId(String newToCheckpointId) {
        this.toCheckpointId = newToCheckpointId;
    }

    @Override
    public boolean toCheckpointIdPresent() {
        return this.toCheckpointId != null;
    }

    @Override
    public List<Disk> disks() {
        return BackupContainer.makeUnmodifiableList(this.disks);
    }

    public void disks(List<Disk> newDisks) {
        this.disks = BackupContainer.makeArrayList(newDisks);
    }

    @Override
    public boolean disksPresent() {
        return this.disks != null && !this.disks.isEmpty();
    }

    @Override
    public Vm vm() {
        return this.vm;
    }

    public void vm(Vm newVm) {
        this.vm = newVm;
    }

    @Override
    public boolean vmPresent() {
        return this.vm != null;
    }
}

