/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IpVersion {
    V4("v4"),
    V6("v6");

    private static final Logger log;
    private String image;

    private IpVersion(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static IpVersion fromValue(String value) {
        try {
            return IpVersion.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'IpVersion' enumerated type. Valid values are 'v4' and 'v6'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(IpVersion.class);
    }
}

