/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.VcpuPin;

public class VcpuPinContainer extends Container implements VcpuPin {
    private String cpuSet;
    private BigInteger vcpu;
    
    public String cpuSet() {
        return cpuSet;
    }
    
    public void cpuSet(String newCpuSet) {
        cpuSet = newCpuSet;
    }
    
    public boolean cpuSetPresent() {
        return cpuSet != null;
    }
    
    public BigInteger vcpu() {
        return vcpu;
    }
    
    public Byte vcpuAsByte() {
        return asByte("VcpuPin", "vcpu", vcpu);
    }
    
    public Short vcpuAsShort() {
        return asShort("VcpuPin", "vcpu", vcpu);
    }
    
    public Integer vcpuAsInteger() {
        return asInteger("VcpuPin", "vcpu", vcpu);
    }
    
    public Long vcpuAsLong() {
        return asLong("VcpuPin", "vcpu", vcpu);
    }
    
    public void vcpu(BigInteger newVcpu) {
        vcpu = newVcpu;
    }
    
    public boolean vcpuPresent() {
        return vcpu != null;
    }
    
}
