/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageDomainTemplateServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.services.StorageDomainTemplateService;
import org.ovirt.engine.sdk4.services.StorageDomainTemplatesService;
import org.ovirt.engine.sdk4.types.Template;

public class StorageDomainTemplatesServiceImpl
extends ServiceImpl
implements StorageDomainTemplatesService {
    public StorageDomainTemplatesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageDomainTemplatesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public StorageDomainTemplateService templateService(String id) {
        return new StorageDomainTemplateServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.templateService(path);
        }
        return this.templateService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "StorageDomainTemplatesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements StorageDomainTemplatesService.ListResponse {
        private List<Template> templates;

        private ListResponseImpl() {
        }

        public void templates(List<Template> templates) {
            this.templates = templates;
        }

        @Override
        public List<Template> templates() {
            return this.templates;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<StorageDomainTemplatesService.ListRequest, StorageDomainTemplatesService.ListResponse>
    implements StorageDomainTemplatesService.ListRequest {
        private String follow;
        private BigInteger max;
        private Boolean unregistered;

        private ListRequestImpl() {
        }

        @Override
        public StorageDomainTemplatesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageDomainTemplatesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public StorageDomainTemplatesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public StorageDomainTemplatesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public StorageDomainTemplatesService.ListRequest unregistered(Boolean unregistered) {
            this.unregistered = unregistered;
            return this;
        }

        @Override
        public StorageDomainTemplatesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainTemplatesServiceImpl.this.getConnection().getUrl() + StorageDomainTemplatesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.unregistered != null) {
                    uriBuilder.addParameter("unregistered", XmlWriter.renderBoolean(this.unregistered));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainTemplatesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.templates(XmlTemplateReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainTemplatesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

