/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.ExternalNetworkProviderConfigurationContainer;
import org.ovirt.engine.sdk4.types.ExternalNetworkProviderConfiguration;
import org.ovirt.engine.sdk4.types.ExternalProvider;
import org.ovirt.engine.sdk4.types.Host;

public class ExternalNetworkProviderConfigurationBuilder {
    private String comment;
    private String description;
    private ExternalProvider externalNetworkProvider;
    private Host host;
    private String href;
    private String id;
    private String name;
    
    public ExternalNetworkProviderConfigurationBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public ExternalNetworkProviderConfigurationBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public ExternalNetworkProviderConfigurationBuilder externalNetworkProvider(ExternalProvider newExternalNetworkProvider) {
        externalNetworkProvider = newExternalNetworkProvider;
        return this;
    }
    
    public ExternalNetworkProviderConfigurationBuilder externalNetworkProvider(ExternalProviderBuilder newExternalNetworkProvider) {
        if (newExternalNetworkProvider == null) {
            externalNetworkProvider = null;
        }
        else {
            externalNetworkProvider = newExternalNetworkProvider.build();
        }
        return this;
    }
    
    
    public ExternalNetworkProviderConfigurationBuilder host(Host newHost) {
        host = newHost;
        return this;
    }
    
    public ExternalNetworkProviderConfigurationBuilder host(HostBuilder newHost) {
        if (newHost == null) {
            host = null;
        }
        else {
            host = newHost.build();
        }
        return this;
    }
    
    
    public ExternalNetworkProviderConfigurationBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public ExternalNetworkProviderConfigurationBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public ExternalNetworkProviderConfigurationBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public ExternalNetworkProviderConfiguration build() {
        ExternalNetworkProviderConfigurationContainer container = new ExternalNetworkProviderConfigurationContainer();
        container.comment(comment);
        container.description(description);
        container.externalNetworkProvider(externalNetworkProvider);
        container.host(host);
        container.href(href);
        container.id(id);
        container.name(name);
        return container;
    }
}
