/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalComputeResourceServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalComputeResourceReader;
import org.ovirt.engine.sdk4.services.ExternalComputeResourceService;
import org.ovirt.engine.sdk4.services.ExternalComputeResourcesService;
import org.ovirt.engine.sdk4.types.ExternalComputeResource;

public class ExternalComputeResourcesServiceImpl
extends ServiceImpl
implements ExternalComputeResourcesService {
    public ExternalComputeResourcesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalComputeResourcesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ExternalComputeResourceService resourceService(String id) {
        return new ExternalComputeResourceServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.resourceService(path);
        }
        return this.resourceService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ExternalComputeResourcesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ExternalComputeResourcesService.ListResponse {
        private List<ExternalComputeResource> resources;

        private ListResponseImpl() {
        }

        public void resources(List<ExternalComputeResource> resources) {
            this.resources = resources;
        }

        @Override
        public List<ExternalComputeResource> resources() {
            return this.resources;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ExternalComputeResourcesService.ListRequest, ExternalComputeResourcesService.ListResponse>
    implements ExternalComputeResourcesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public ExternalComputeResourcesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalComputeResourcesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public ExternalComputeResourcesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public ExternalComputeResourcesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public ExternalComputeResourcesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalComputeResourcesServiceImpl.this.getConnection().getUrl() + ExternalComputeResourcesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalComputeResourcesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.resources(XmlExternalComputeResourceReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalComputeResourcesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

