/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.NetworkServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkWriter;
import org.ovirt.engine.sdk4.services.NetworkService;
import org.ovirt.engine.sdk4.services.NetworksService;
import org.ovirt.engine.sdk4.types.Network;

public class NetworksServiceImpl
extends ServiceImpl
implements NetworksService {
    public NetworksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public NetworksService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public NetworksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public NetworkService networkService(String id) {
        return new NetworkServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.networkService(path);
        }
        return this.networkService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "NetworksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements NetworksService.ListResponse {
        private List<Network> networks;

        private ListResponseImpl() {
        }

        public void networks(List<Network> networks) {
            this.networks = networks;
        }

        @Override
        public List<Network> networks() {
            return this.networks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<NetworksService.ListRequest, NetworksService.ListResponse>
    implements NetworksService.ListRequest {
        private Boolean caseSensitive;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public NetworksService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public NetworksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public NetworksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public NetworksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public NetworksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public NetworksService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public NetworksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworksServiceImpl.this.getConnection().getUrl() + NetworksServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.networks(XmlNetworkReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements NetworksService.AddResponse {
        private Network network;

        private AddResponseImpl() {
        }

        public void network(Network network) {
            this.network = network;
        }

        @Override
        public Network network() {
            return this.network;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<NetworksService.AddRequest, NetworksService.AddResponse>
    implements NetworksService.AddRequest {
        private Network network;

        private AddRequestImpl() {
        }

        @Override
        public NetworksService.AddRequest network(Network network) {
            this.network = network;
            return this;
        }

        @Override
        public NetworksService.AddRequest network(NetworkBuilder network) {
            this.network = network.build();
            return this;
        }

        @Override
        public NetworksService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworksServiceImpl.this.getConnection().getUrl() + NetworksServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkWriter.writeOne(this.network, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.network(XmlNetworkReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworksServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

