/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageDomainServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainWriter;
import org.ovirt.engine.sdk4.services.StorageDomainService;
import org.ovirt.engine.sdk4.services.StorageDomainsService;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class StorageDomainsServiceImpl
extends ServiceImpl
implements StorageDomainsService {
    public StorageDomainsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageDomainsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public StorageDomainsService.AddBlockDomainRequest addBlockDomain() {
        return new AddBlockDomainRequestImpl();
    }

    @Override
    public StorageDomainsService.AddByPathRequest addByPath() {
        return new AddByPathRequestImpl();
    }

    @Override
    public StorageDomainsService.AddDirectLunRequest addDirectLun() {
        return new AddDirectLunRequestImpl();
    }

    @Override
    public StorageDomainsService.AddGlusterOrPostfsRequest addGlusterOrPostfs() {
        return new AddGlusterOrPostfsRequestImpl();
    }

    @Override
    public StorageDomainsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public StorageDomainsService.AddLocalRequest addLocal() {
        return new AddLocalRequestImpl();
    }

    @Override
    public StorageDomainService storageDomainService(String id) {
        return new StorageDomainServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.storageDomainService(path);
        }
        return this.storageDomainService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "StorageDomainsService:" + this.getPath();
    }

    private class AddLocalResponseImpl
    implements StorageDomainsService.AddLocalResponse {
        private StorageDomain storageDomain;

        private AddLocalResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddLocalRequestImpl
    extends BaseRequest<StorageDomainsService.AddLocalRequest, StorageDomainsService.AddLocalResponse>
    implements StorageDomainsService.AddLocalRequest {
        private StorageDomain storageDomain;

        private AddLocalRequestImpl() {
        }

        @Override
        public StorageDomainsService.AddLocalRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainsService.AddLocalRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainsService.AddLocalResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddLocalResponseImpl actionResponse = new AddLocalResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddLocalResponseImpl addLocalResponseImpl = actionResponse;
                        reader.close();
                        return addLocalResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new AddLocalResponseImpl();
        }
    }

    private class ListResponseImpl
    implements StorageDomainsService.ListResponse {
        private List<StorageDomain> storageDomains;

        private ListResponseImpl() {
        }

        public void storageDomains(List<StorageDomain> storageDomains) {
            this.storageDomains = storageDomains;
        }

        @Override
        public List<StorageDomain> storageDomains() {
            return this.storageDomains;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<StorageDomainsService.ListRequest, StorageDomainsService.ListResponse>
    implements StorageDomainsService.ListRequest {
        private Boolean caseSensitive;
        private Boolean filter;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public StorageDomainsService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public StorageDomainsService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public StorageDomainsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageDomainsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public StorageDomainsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public StorageDomainsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public StorageDomainsService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public StorageDomainsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.storageDomains(XmlStorageDomainReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddGlusterOrPostfsResponseImpl
    implements StorageDomainsService.AddGlusterOrPostfsResponse {
        private StorageDomain storageDomain;

        private AddGlusterOrPostfsResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddGlusterOrPostfsRequestImpl
    extends BaseRequest<StorageDomainsService.AddGlusterOrPostfsRequest, StorageDomainsService.AddGlusterOrPostfsResponse>
    implements StorageDomainsService.AddGlusterOrPostfsRequest {
        private StorageDomain storageDomain;

        private AddGlusterOrPostfsRequestImpl() {
        }

        @Override
        public StorageDomainsService.AddGlusterOrPostfsRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainsService.AddGlusterOrPostfsRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainsService.AddGlusterOrPostfsResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddGlusterOrPostfsResponseImpl actionResponse = new AddGlusterOrPostfsResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddGlusterOrPostfsResponseImpl addGlusterOrPostfsResponseImpl = actionResponse;
                        reader.close();
                        return addGlusterOrPostfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new AddGlusterOrPostfsResponseImpl();
        }
    }

    private class AddDirectLunResponseImpl
    implements StorageDomainsService.AddDirectLunResponse {
        private StorageDomain storageDomain;

        private AddDirectLunResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddDirectLunRequestImpl
    extends BaseRequest<StorageDomainsService.AddDirectLunRequest, StorageDomainsService.AddDirectLunResponse>
    implements StorageDomainsService.AddDirectLunRequest {
        private StorageDomain storageDomain;

        private AddDirectLunRequestImpl() {
        }

        @Override
        public StorageDomainsService.AddDirectLunRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainsService.AddDirectLunRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainsService.AddDirectLunResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddDirectLunResponseImpl actionResponse = new AddDirectLunResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddDirectLunResponseImpl addDirectLunResponseImpl = actionResponse;
                        reader.close();
                        return addDirectLunResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new AddDirectLunResponseImpl();
        }
    }

    private class AddByPathResponseImpl
    implements StorageDomainsService.AddByPathResponse {
        private StorageDomain storageDomain;

        private AddByPathResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddByPathRequestImpl
    extends BaseRequest<StorageDomainsService.AddByPathRequest, StorageDomainsService.AddByPathResponse>
    implements StorageDomainsService.AddByPathRequest {
        private StorageDomain storageDomain;

        private AddByPathRequestImpl() {
        }

        @Override
        public StorageDomainsService.AddByPathRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainsService.AddByPathRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainsService.AddByPathResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddByPathResponseImpl actionResponse = new AddByPathResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddByPathResponseImpl addByPathResponseImpl = actionResponse;
                        reader.close();
                        return addByPathResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new AddByPathResponseImpl();
        }
    }

    private class AddBlockDomainResponseImpl
    implements StorageDomainsService.AddBlockDomainResponse {
        private StorageDomain storageDomain;

        private AddBlockDomainResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddBlockDomainRequestImpl
    extends BaseRequest<StorageDomainsService.AddBlockDomainRequest, StorageDomainsService.AddBlockDomainResponse>
    implements StorageDomainsService.AddBlockDomainRequest {
        private StorageDomain storageDomain;

        private AddBlockDomainRequestImpl() {
        }

        @Override
        public StorageDomainsService.AddBlockDomainRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainsService.AddBlockDomainRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainsService.AddBlockDomainResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddBlockDomainResponseImpl actionResponse = new AddBlockDomainResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddBlockDomainResponseImpl addBlockDomainResponseImpl = actionResponse;
                        reader.close();
                        return addBlockDomainResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new AddBlockDomainResponseImpl();
        }
    }

    private class AddResponseImpl
    implements StorageDomainsService.AddResponse {
        private StorageDomain storageDomain;

        private AddResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<StorageDomainsService.AddRequest, StorageDomainsService.AddResponse>
    implements StorageDomainsService.AddRequest {
        private StorageDomain storageDomain;

        private AddRequestImpl() {
        }

        @Override
        public StorageDomainsService.AddRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainsService.AddRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainsServiceImpl.this.getConnection().getUrl() + StorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

