/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.MeasurableServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StatisticsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainDiskService;
import org.ovirt.engine.sdk4.services.StatisticsService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class AttachedStorageDomainDiskServiceImpl
extends MeasurableServiceImpl
implements AttachedStorageDomainDiskService {
    public AttachedStorageDomainDiskServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AttachedStorageDomainDiskService.CopyRequest copy() {
        return new CopyRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.ExportRequest export() {
        return new ExportRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.MoveRequest move() {
        return new MoveRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.RegisterRequest register() {
        return new RegisterRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.SparsifyRequest sparsify() {
        return new SparsifyRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public StatisticsService statisticsService() {
        return new StatisticsServiceImpl(this.getConnection(), this.getPath() + "/statistics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("statistics")) {
            return this.statisticsService();
        }
        if (path.startsWith("statistics/")) {
            return this.statisticsService().service(path.substring(11));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "AttachedStorageDomainDiskService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements AttachedStorageDomainDiskService.UpdateResponse {
        private Disk disk;

        private UpdateResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.UpdateRequest, AttachedStorageDomainDiskService.UpdateResponse>
    implements AttachedStorageDomainDiskService.UpdateRequest {
        private Disk disk;

        private UpdateRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.UpdateRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.UpdateRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskWriter.writeOne(this.disk, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainDiskServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class SparsifyResponseImpl
    implements AttachedStorageDomainDiskService.SparsifyResponse {
        private SparsifyResponseImpl() {
        }
    }

    private class SparsifyRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.SparsifyRequest, AttachedStorageDomainDiskService.SparsifyResponse>
    implements AttachedStorageDomainDiskService.SparsifyRequest {
        private SparsifyRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.SparsifyResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath() + "/sparsify");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new SparsifyResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements AttachedStorageDomainDiskService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.RemoveRequest, AttachedStorageDomainDiskService.RemoveResponse>
    implements AttachedStorageDomainDiskService.RemoveRequest {
        private RemoveRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            AttachedStorageDomainDiskServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class RegisterResponseImpl
    implements AttachedStorageDomainDiskService.RegisterResponse {
        private RegisterResponseImpl() {
        }
    }

    private class RegisterRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.RegisterRequest, AttachedStorageDomainDiskService.RegisterResponse>
    implements AttachedStorageDomainDiskService.RegisterRequest {
        private RegisterRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.RegisterResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath() + "/register");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new RegisterResponseImpl();
        }
    }

    private class MoveResponseImpl
    implements AttachedStorageDomainDiskService.MoveResponse {
        private MoveResponseImpl() {
        }
    }

    private class MoveRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.MoveRequest, AttachedStorageDomainDiskService.MoveResponse>
    implements AttachedStorageDomainDiskService.MoveRequest {
        private Boolean async;
        private Boolean filter;
        private StorageDomain storageDomain;

        private MoveRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.MoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.MoveRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.MoveRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.MoveRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.MoveResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath() + "/move");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.filter(this.filter);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new MoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements AttachedStorageDomainDiskService.GetResponse {
        private Disk disk;

        private GetResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.GetRequest, AttachedStorageDomainDiskService.GetResponse>
    implements AttachedStorageDomainDiskService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainDiskServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class ExportResponseImpl
    implements AttachedStorageDomainDiskService.ExportResponse {
        private ExportResponseImpl() {
        }
    }

    private class ExportRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.ExportRequest, AttachedStorageDomainDiskService.ExportResponse>
    implements AttachedStorageDomainDiskService.ExportRequest {
        private StorageDomain storageDomain;

        private ExportRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.ExportRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.ExportRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.ExportResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportResponseImpl();
        }
    }

    private class CopyResponseImpl
    implements AttachedStorageDomainDiskService.CopyResponse {
        private CopyResponseImpl() {
        }
    }

    private class CopyRequestImpl
    extends BaseRequest<AttachedStorageDomainDiskService.CopyRequest, AttachedStorageDomainDiskService.CopyResponse>
    implements AttachedStorageDomainDiskService.CopyRequest {
        private Disk disk;
        private StorageDomain storageDomain;

        private CopyRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDiskService.CopyRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.CopyRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.CopyRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.CopyRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public AttachedStorageDomainDiskService.CopyResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainDiskServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDiskServiceImpl.this.getPath() + "/copy");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.disk(this.disk);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new CopyResponseImpl();
        }
    }
}

