/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.SshPublicKeyBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.SshPublicKeyServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlSshPublicKeyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSshPublicKeyWriter;
import org.ovirt.engine.sdk4.services.SshPublicKeyService;
import org.ovirt.engine.sdk4.services.SshPublicKeysService;
import org.ovirt.engine.sdk4.types.SshPublicKey;

public class SshPublicKeysServiceImpl
extends ServiceImpl
implements SshPublicKeysService {
    public SshPublicKeysServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SshPublicKeysService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public SshPublicKeysService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public SshPublicKeyService keyService(String id) {
        return new SshPublicKeyServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.keyService(path);
        }
        return this.keyService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "SshPublicKeysService:" + this.getPath();
    }

    private class ListResponseImpl
    implements SshPublicKeysService.ListResponse {
        private List<SshPublicKey> keys;

        private ListResponseImpl() {
        }

        public void keys(List<SshPublicKey> keys) {
            this.keys = keys;
        }

        @Override
        public List<SshPublicKey> keys() {
            return this.keys;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<SshPublicKeysService.ListRequest, SshPublicKeysService.ListResponse>
    implements SshPublicKeysService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public SshPublicKeysService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public SshPublicKeysService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public SshPublicKeysService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public SshPublicKeysService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public SshPublicKeysService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SshPublicKeysServiceImpl.this.getConnection().getUrl() + SshPublicKeysServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SshPublicKeysServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.keys(XmlSshPublicKeyReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SshPublicKeysServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements SshPublicKeysService.AddResponse {
        private SshPublicKey key;

        private AddResponseImpl() {
        }

        public void key(SshPublicKey key) {
            this.key = key;
        }

        @Override
        public SshPublicKey key() {
            return this.key;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<SshPublicKeysService.AddRequest, SshPublicKeysService.AddResponse>
    implements SshPublicKeysService.AddRequest {
        private SshPublicKey key;

        private AddRequestImpl() {
        }

        @Override
        public SshPublicKeysService.AddRequest key(SshPublicKey key) {
            this.key = key;
            return this;
        }

        @Override
        public SshPublicKeysService.AddRequest key(SshPublicKeyBuilder key) {
            this.key = key.build();
            return this;
        }

        @Override
        public SshPublicKeysService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SshPublicKeysServiceImpl.this.getConnection().getUrl() + SshPublicKeysServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlSshPublicKeyWriter.writeOne(this.key, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SshPublicKeysServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.key(XmlSshPublicKeyReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SshPublicKeysServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

