/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmBackupDisksServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlBackupReader;
import org.ovirt.engine.sdk4.services.VmBackupDisksService;
import org.ovirt.engine.sdk4.services.VmBackupService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Backup;

public class VmBackupServiceImpl
extends ServiceImpl
implements VmBackupService {
    public VmBackupServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmBackupService.FinalizeRequest finalize_() {
        return new FinalizeRequestImpl();
    }

    @Override
    public VmBackupService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public VmBackupDisksService disksService() {
        return new VmBackupDisksServiceImpl(this.getConnection(), this.getPath() + "/disks");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("disks")) {
            return this.disksService();
        }
        if (path.startsWith("disks/")) {
            return this.disksService().service(path.substring(6));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "VmBackupService:" + this.getPath();
    }

    private class GetResponseImpl
    implements VmBackupService.GetResponse {
        private Backup backup;

        private GetResponseImpl() {
        }

        public void backup(Backup backup) {
            this.backup = backup;
        }

        @Override
        public Backup backup() {
            return this.backup;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmBackupService.GetRequest, VmBackupService.GetResponse>
    implements VmBackupService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmBackupService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmBackupService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmBackupServiceImpl.this.getConnection().getUrl() + VmBackupServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmBackupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.backup(XmlBackupReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmBackupServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class FinalizeResponseImpl
    implements VmBackupService.FinalizeResponse {
        private FinalizeResponseImpl() {
        }
    }

    private class FinalizeRequestImpl
    extends BaseRequest<VmBackupService.FinalizeRequest, VmBackupService.FinalizeResponse>
    implements VmBackupService.FinalizeRequest {
        private FinalizeRequestImpl() {
        }

        @Override
        public VmBackupService.FinalizeResponse send() {
            HttpPost request = new HttpPost(VmBackupServiceImpl.this.getConnection().getUrl() + VmBackupServiceImpl.this.getPath() + "/finalize");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmBackupServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmBackupServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new FinalizeResponseImpl();
        }
    }
}

