/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DiskStorageType {
    CINDER("cinder"),
    IMAGE("image"),
    LUN("lun"),
    MANAGED_BLOCK_STORAGE("managed_block_storage");

    private static final Logger log;
    private String image;

    private DiskStorageType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static DiskStorageType fromValue(String value) {
        try {
            return DiskStorageType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'DiskStorageType' enumerated type. Valid values are 'cinder', 'image', 'lun' and 'managed_block_storage'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(DiskStorageType.class);
    }
}

