/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DiskProfileBuilder;
import org.ovirt.engine.sdk4.builders.DiskSnapshotBuilder;
import org.ovirt.engine.sdk4.builders.HostStorageBuilder;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.OpenStackVolumeTypeBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.builders.SnapshotBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.DiskContainer;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskBackup;
import org.ovirt.engine.sdk4.types.DiskBackupMode;
import org.ovirt.engine.sdk4.types.DiskContentType;
import org.ovirt.engine.sdk4.types.DiskFormat;
import org.ovirt.engine.sdk4.types.DiskInterface;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.DiskSnapshot;
import org.ovirt.engine.sdk4.types.DiskStatus;
import org.ovirt.engine.sdk4.types.DiskStorageType;
import org.ovirt.engine.sdk4.types.HostStorage;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.OpenStackVolumeType;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.QcowVersion;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.ScsiGenericIO;
import org.ovirt.engine.sdk4.types.Snapshot;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class DiskBuilder {
    private Boolean active;
    private BigInteger actualSize;
    private String alias;
    private DiskBackup backup;
    private DiskBackupMode backupMode;
    private Boolean bootable;
    private String comment;
    private DiskContentType contentType;
    private String description;
    private DiskProfile diskProfile;
    private List<DiskSnapshot> diskSnapshots;
    private String externalDisk;
    private DiskFormat format;
    private String href;
    private String id;
    private String imageId;
    private BigInteger initialSize;
    private InstanceType instanceType;
    private DiskInterface interface_;
    private String logicalName;
    private HostStorage lunStorage;
    private String name;
    private OpenStackVolumeType openstackVolumeType;
    private List<Permission> permissions;
    private Boolean propagateErrors;
    private BigInteger provisionedSize;
    private QcowVersion qcowVersion;
    private Quota quota;
    private Boolean readOnly;
    private ScsiGenericIO sgio;
    private Boolean shareable;
    private Snapshot snapshot;
    private Boolean sparse;
    private List<Statistic> statistics;
    private DiskStatus status;
    private StorageDomain storageDomain;
    private List<StorageDomain> storageDomains;
    private DiskStorageType storageType;
    private Template template;
    private BigInteger totalSize;
    private Boolean usesScsiReservation;
    private Vm vm;
    private List<Vm> vms;
    private Boolean wipeAfterDelete;

    public DiskBuilder active(boolean newActive) {
        this.active = newActive;
        return this;
    }

    public DiskBuilder active(Boolean newActive) {
        this.active = newActive;
        return this;
    }

    public DiskBuilder actualSize(int newActualSize) {
        this.actualSize = BigInteger.valueOf(newActualSize);
        return this;
    }

    public DiskBuilder actualSize(Integer newActualSize) {
        this.actualSize = newActualSize == null ? null : BigInteger.valueOf(newActualSize.longValue());
        return this;
    }

    public DiskBuilder actualSize(long newActualSize) {
        this.actualSize = BigInteger.valueOf(newActualSize);
        return this;
    }

    public DiskBuilder actualSize(Long newActualSize) {
        this.actualSize = newActualSize == null ? null : BigInteger.valueOf(newActualSize);
        return this;
    }

    public DiskBuilder actualSize(BigInteger newActualSize) {
        this.actualSize = newActualSize;
        return this;
    }

    public DiskBuilder alias(String newAlias) {
        this.alias = newAlias;
        return this;
    }

    public DiskBuilder backup(DiskBackup newBackup) {
        this.backup = newBackup;
        return this;
    }

    public DiskBuilder backupMode(DiskBackupMode newBackupMode) {
        this.backupMode = newBackupMode;
        return this;
    }

    public DiskBuilder bootable(boolean newBootable) {
        this.bootable = newBootable;
        return this;
    }

    public DiskBuilder bootable(Boolean newBootable) {
        this.bootable = newBootable;
        return this;
    }

    public DiskBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public DiskBuilder contentType(DiskContentType newContentType) {
        this.contentType = newContentType;
        return this;
    }

    public DiskBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DiskBuilder diskProfile(DiskProfile newDiskProfile) {
        this.diskProfile = newDiskProfile;
        return this;
    }

    public DiskBuilder diskProfile(DiskProfileBuilder newDiskProfile) {
        this.diskProfile = newDiskProfile == null ? null : newDiskProfile.build();
        return this;
    }

    public DiskBuilder diskSnapshots(List<DiskSnapshot> newDiskSnapshots) {
        if (newDiskSnapshots != null) {
            if (this.diskSnapshots == null) {
                this.diskSnapshots = new ArrayList<DiskSnapshot>(newDiskSnapshots);
            } else {
                this.diskSnapshots.addAll(newDiskSnapshots);
            }
        }
        return this;
    }

    public DiskBuilder diskSnapshots(DiskSnapshot ... newDiskSnapshots) {
        if (newDiskSnapshots != null) {
            if (this.diskSnapshots == null) {
                this.diskSnapshots = new ArrayList<DiskSnapshot>(newDiskSnapshots.length);
            }
            Collections.addAll(this.diskSnapshots, newDiskSnapshots);
        }
        return this;
    }

    public DiskBuilder diskSnapshots(DiskSnapshotBuilder ... newDiskSnapshots) {
        if (newDiskSnapshots != null) {
            if (this.diskSnapshots == null) {
                this.diskSnapshots = new ArrayList<DiskSnapshot>(newDiskSnapshots.length);
            }
            for (DiskSnapshotBuilder builder : newDiskSnapshots) {
                this.diskSnapshots.add(builder.build());
            }
        }
        return this;
    }

    public DiskBuilder externalDisk(String newExternalDisk) {
        this.externalDisk = newExternalDisk;
        return this;
    }

    public DiskBuilder format(DiskFormat newFormat) {
        this.format = newFormat;
        return this;
    }

    public DiskBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public DiskBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public DiskBuilder imageId(String newImageId) {
        this.imageId = newImageId;
        return this;
    }

    public DiskBuilder initialSize(int newInitialSize) {
        this.initialSize = BigInteger.valueOf(newInitialSize);
        return this;
    }

    public DiskBuilder initialSize(Integer newInitialSize) {
        this.initialSize = newInitialSize == null ? null : BigInteger.valueOf(newInitialSize.longValue());
        return this;
    }

    public DiskBuilder initialSize(long newInitialSize) {
        this.initialSize = BigInteger.valueOf(newInitialSize);
        return this;
    }

    public DiskBuilder initialSize(Long newInitialSize) {
        this.initialSize = newInitialSize == null ? null : BigInteger.valueOf(newInitialSize);
        return this;
    }

    public DiskBuilder initialSize(BigInteger newInitialSize) {
        this.initialSize = newInitialSize;
        return this;
    }

    public DiskBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public DiskBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public DiskBuilder interface_(DiskInterface newInterface) {
        this.interface_ = newInterface;
        return this;
    }

    public DiskBuilder logicalName(String newLogicalName) {
        this.logicalName = newLogicalName;
        return this;
    }

    public DiskBuilder lunStorage(HostStorage newLunStorage) {
        this.lunStorage = newLunStorage;
        return this;
    }

    public DiskBuilder lunStorage(HostStorageBuilder newLunStorage) {
        this.lunStorage = newLunStorage == null ? null : newLunStorage.build();
        return this;
    }

    public DiskBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public DiskBuilder openstackVolumeType(OpenStackVolumeType newOpenstackVolumeType) {
        this.openstackVolumeType = newOpenstackVolumeType;
        return this;
    }

    public DiskBuilder openstackVolumeType(OpenStackVolumeTypeBuilder newOpenstackVolumeType) {
        this.openstackVolumeType = newOpenstackVolumeType == null ? null : newOpenstackVolumeType.build();
        return this;
    }

    public DiskBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public DiskBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public DiskBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public DiskBuilder propagateErrors(boolean newPropagateErrors) {
        this.propagateErrors = newPropagateErrors;
        return this;
    }

    public DiskBuilder propagateErrors(Boolean newPropagateErrors) {
        this.propagateErrors = newPropagateErrors;
        return this;
    }

    public DiskBuilder provisionedSize(int newProvisionedSize) {
        this.provisionedSize = BigInteger.valueOf(newProvisionedSize);
        return this;
    }

    public DiskBuilder provisionedSize(Integer newProvisionedSize) {
        this.provisionedSize = newProvisionedSize == null ? null : BigInteger.valueOf(newProvisionedSize.longValue());
        return this;
    }

    public DiskBuilder provisionedSize(long newProvisionedSize) {
        this.provisionedSize = BigInteger.valueOf(newProvisionedSize);
        return this;
    }

    public DiskBuilder provisionedSize(Long newProvisionedSize) {
        this.provisionedSize = newProvisionedSize == null ? null : BigInteger.valueOf(newProvisionedSize);
        return this;
    }

    public DiskBuilder provisionedSize(BigInteger newProvisionedSize) {
        this.provisionedSize = newProvisionedSize;
        return this;
    }

    public DiskBuilder qcowVersion(QcowVersion newQcowVersion) {
        this.qcowVersion = newQcowVersion;
        return this;
    }

    public DiskBuilder quota(Quota newQuota) {
        this.quota = newQuota;
        return this;
    }

    public DiskBuilder quota(QuotaBuilder newQuota) {
        this.quota = newQuota == null ? null : newQuota.build();
        return this;
    }

    public DiskBuilder readOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public DiskBuilder readOnly(Boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public DiskBuilder sgio(ScsiGenericIO newSgio) {
        this.sgio = newSgio;
        return this;
    }

    public DiskBuilder shareable(boolean newShareable) {
        this.shareable = newShareable;
        return this;
    }

    public DiskBuilder shareable(Boolean newShareable) {
        this.shareable = newShareable;
        return this;
    }

    public DiskBuilder snapshot(Snapshot newSnapshot) {
        this.snapshot = newSnapshot;
        return this;
    }

    public DiskBuilder snapshot(SnapshotBuilder newSnapshot) {
        this.snapshot = newSnapshot == null ? null : newSnapshot.build();
        return this;
    }

    public DiskBuilder sparse(boolean newSparse) {
        this.sparse = newSparse;
        return this;
    }

    public DiskBuilder sparse(Boolean newSparse) {
        this.sparse = newSparse;
        return this;
    }

    public DiskBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public DiskBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public DiskBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public DiskBuilder status(DiskStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public DiskBuilder storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
        return this;
    }

    public DiskBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        this.storageDomain = newStorageDomain == null ? null : newStorageDomain.build();
        return this;
    }

    public DiskBuilder storageDomains(List<StorageDomain> newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains);
            } else {
                this.storageDomains.addAll(newStorageDomains);
            }
        }
        return this;
    }

    public DiskBuilder storageDomains(StorageDomain ... newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains.length);
            }
            Collections.addAll(this.storageDomains, newStorageDomains);
        }
        return this;
    }

    public DiskBuilder storageDomains(StorageDomainBuilder ... newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains.length);
            }
            for (StorageDomainBuilder builder : newStorageDomains) {
                this.storageDomains.add(builder.build());
            }
        }
        return this;
    }

    public DiskBuilder storageType(DiskStorageType newStorageType) {
        this.storageType = newStorageType;
        return this;
    }

    public DiskBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public DiskBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public DiskBuilder totalSize(int newTotalSize) {
        this.totalSize = BigInteger.valueOf(newTotalSize);
        return this;
    }

    public DiskBuilder totalSize(Integer newTotalSize) {
        this.totalSize = newTotalSize == null ? null : BigInteger.valueOf(newTotalSize.longValue());
        return this;
    }

    public DiskBuilder totalSize(long newTotalSize) {
        this.totalSize = BigInteger.valueOf(newTotalSize);
        return this;
    }

    public DiskBuilder totalSize(Long newTotalSize) {
        this.totalSize = newTotalSize == null ? null : BigInteger.valueOf(newTotalSize);
        return this;
    }

    public DiskBuilder totalSize(BigInteger newTotalSize) {
        this.totalSize = newTotalSize;
        return this;
    }

    public DiskBuilder usesScsiReservation(boolean newUsesScsiReservation) {
        this.usesScsiReservation = newUsesScsiReservation;
        return this;
    }

    public DiskBuilder usesScsiReservation(Boolean newUsesScsiReservation) {
        this.usesScsiReservation = newUsesScsiReservation;
        return this;
    }

    public DiskBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public DiskBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public DiskBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public DiskBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public DiskBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public DiskBuilder wipeAfterDelete(boolean newWipeAfterDelete) {
        this.wipeAfterDelete = newWipeAfterDelete;
        return this;
    }

    public DiskBuilder wipeAfterDelete(Boolean newWipeAfterDelete) {
        this.wipeAfterDelete = newWipeAfterDelete;
        return this;
    }

    public Disk build() {
        DiskContainer container = new DiskContainer();
        container.active(this.active);
        container.actualSize(this.actualSize);
        container.alias(this.alias);
        container.backup(this.backup);
        container.backupMode(this.backupMode);
        container.bootable(this.bootable);
        container.comment(this.comment);
        container.contentType(this.contentType);
        container.description(this.description);
        container.diskProfile(this.diskProfile);
        container.diskSnapshots(this.diskSnapshots);
        container.externalDisk(this.externalDisk);
        container.format(this.format);
        container.href(this.href);
        container.id(this.id);
        container.imageId(this.imageId);
        container.initialSize(this.initialSize);
        container.instanceType(this.instanceType);
        container.interface_(this.interface_);
        container.logicalName(this.logicalName);
        container.lunStorage(this.lunStorage);
        container.name(this.name);
        container.openstackVolumeType(this.openstackVolumeType);
        container.permissions(this.permissions);
        container.propagateErrors(this.propagateErrors);
        container.provisionedSize(this.provisionedSize);
        container.qcowVersion(this.qcowVersion);
        container.quota(this.quota);
        container.readOnly(this.readOnly);
        container.sgio(this.sgio);
        container.shareable(this.shareable);
        container.snapshot(this.snapshot);
        container.sparse(this.sparse);
        container.statistics(this.statistics);
        container.status(this.status);
        container.storageDomain(this.storageDomain);
        container.storageDomains(this.storageDomains);
        container.storageType(this.storageType);
        container.template(this.template);
        container.totalSize(this.totalSize);
        container.usesScsiReservation(this.usesScsiReservation);
        container.vm(this.vm);
        container.vms(this.vms);
        container.wipeAfterDelete(this.wipeAfterDelete);
        return container;
    }
}

