/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ClusterFeatureBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ClusterEnabledFeatureServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterFeatureReader;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterFeatureWriter;
import org.ovirt.engine.sdk4.services.ClusterEnabledFeatureService;
import org.ovirt.engine.sdk4.services.ClusterEnabledFeaturesService;
import org.ovirt.engine.sdk4.types.ClusterFeature;

public class ClusterEnabledFeaturesServiceImpl
extends ServiceImpl
implements ClusterEnabledFeaturesService {
    public ClusterEnabledFeaturesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ClusterEnabledFeaturesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public ClusterEnabledFeaturesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ClusterEnabledFeatureService featureService(String id) {
        return new ClusterEnabledFeatureServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.featureService(path);
        }
        return this.featureService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ClusterEnabledFeaturesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ClusterEnabledFeaturesService.ListResponse {
        private List<ClusterFeature> features;

        private ListResponseImpl() {
        }

        public void features(List<ClusterFeature> features) {
            this.features = features;
        }

        @Override
        public List<ClusterFeature> features() {
            return this.features;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ClusterEnabledFeaturesService.ListRequest, ClusterEnabledFeaturesService.ListResponse>
    implements ClusterEnabledFeaturesService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public ClusterEnabledFeaturesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ClusterEnabledFeaturesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterEnabledFeaturesServiceImpl.this.getConnection().getUrl() + ClusterEnabledFeaturesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterEnabledFeaturesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.features(XmlClusterFeatureReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterEnabledFeaturesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements ClusterEnabledFeaturesService.AddResponse {
        private ClusterFeature feature;

        private AddResponseImpl() {
        }

        public void feature(ClusterFeature feature) {
            this.feature = feature;
        }

        @Override
        public ClusterFeature feature() {
            return this.feature;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<ClusterEnabledFeaturesService.AddRequest, ClusterEnabledFeaturesService.AddResponse>
    implements ClusterEnabledFeaturesService.AddRequest {
        private ClusterFeature feature;

        private AddRequestImpl() {
        }

        @Override
        public ClusterEnabledFeaturesService.AddRequest feature(ClusterFeature feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public ClusterEnabledFeaturesService.AddRequest feature(ClusterFeatureBuilder feature) {
            this.feature = feature.build();
            return this;
        }

        @Override
        public ClusterEnabledFeaturesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterEnabledFeaturesServiceImpl.this.getConnection().getUrl() + ClusterEnabledFeaturesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlClusterFeatureWriter.writeOne(this.feature, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterEnabledFeaturesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.feature(XmlClusterFeatureReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterEnabledFeaturesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

