/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.GraphicsConsoleBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmGraphicsConsoleServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlGraphicsConsoleReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGraphicsConsoleWriter;
import org.ovirt.engine.sdk4.services.VmGraphicsConsoleService;
import org.ovirt.engine.sdk4.services.VmGraphicsConsolesService;
import org.ovirt.engine.sdk4.types.GraphicsConsole;

public class VmGraphicsConsolesServiceImpl
extends ServiceImpl
implements VmGraphicsConsolesService {
    public VmGraphicsConsolesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmGraphicsConsolesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmGraphicsConsolesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmGraphicsConsoleService consoleService(String id) {
        return new VmGraphicsConsoleServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.consoleService(path);
        }
        return this.consoleService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmGraphicsConsolesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmGraphicsConsolesService.ListResponse {
        private List<GraphicsConsole> consoles;

        private ListResponseImpl() {
        }

        public void consoles(List<GraphicsConsole> consoles) {
            this.consoles = consoles;
        }

        @Override
        public List<GraphicsConsole> consoles() {
            return this.consoles;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmGraphicsConsolesService.ListRequest, VmGraphicsConsolesService.ListResponse>
    implements VmGraphicsConsolesService.ListRequest {
        private Boolean current;
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VmGraphicsConsolesService.ListRequest current(Boolean current) {
            this.current = current;
            return this;
        }

        @Override
        public VmGraphicsConsolesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmGraphicsConsolesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmGraphicsConsolesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmGraphicsConsolesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmGraphicsConsolesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmGraphicsConsolesServiceImpl.this.getConnection().getUrl() + VmGraphicsConsolesServiceImpl.this.getPath());
                if (this.current != null) {
                    uriBuilder.addParameter("current", XmlWriter.renderBoolean(this.current));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmGraphicsConsolesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.consoles(XmlGraphicsConsoleReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmGraphicsConsolesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmGraphicsConsolesService.AddResponse {
        private GraphicsConsole console;

        private AddResponseImpl() {
        }

        public void console(GraphicsConsole console) {
            this.console = console;
        }

        @Override
        public GraphicsConsole console() {
            return this.console;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmGraphicsConsolesService.AddRequest, VmGraphicsConsolesService.AddResponse>
    implements VmGraphicsConsolesService.AddRequest {
        private GraphicsConsole console;

        private AddRequestImpl() {
        }

        @Override
        public VmGraphicsConsolesService.AddRequest console(GraphicsConsole console) {
            this.console = console;
            return this;
        }

        @Override
        public VmGraphicsConsolesService.AddRequest console(GraphicsConsoleBuilder console) {
            this.console = console.build();
            return this;
        }

        @Override
        public VmGraphicsConsolesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmGraphicsConsolesServiceImpl.this.getConnection().getUrl() + VmGraphicsConsolesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlGraphicsConsoleWriter.writeOne(this.console, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmGraphicsConsolesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.console(XmlGraphicsConsoleReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmGraphicsConsolesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

