/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.NetworkContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDnsResolverConfigurationReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIpReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkUsageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackNetworkProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQosReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVlanReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVnicProfileReader;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class XmlNetworkReader {
    public static Network readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        NetworkContainer object = new NetworkContainer();
        block60: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block60;
                }
                case "id": {
                    object.id(image);
                    continue block60;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block61: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "cluster": {
                    object.cluster(XmlClusterReader.readOne(reader));
                    continue block61;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block61;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block61;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block61;
                }
                case "display": {
                    object.display(reader.readBoolean());
                    continue block61;
                }
                case "dns_resolver_configuration": {
                    object.dnsResolverConfiguration(XmlDnsResolverConfigurationReader.readOne(reader));
                    continue block61;
                }
                case "external_provider": {
                    object.externalProvider(XmlOpenStackNetworkProviderReader.readOne(reader));
                    continue block61;
                }
                case "external_provider_physical_network": {
                    object.externalProviderPhysicalNetwork(XmlNetworkReader.readOne(reader));
                    continue block61;
                }
                case "ip": {
                    object.ip(XmlIpReader.readOne(reader));
                    continue block61;
                }
                case "mtu": {
                    object.mtu(reader.readInteger());
                    continue block61;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block61;
                }
                case "network_labels": {
                    object.networkLabels(XmlNetworkLabelReader.readMany(reader));
                    continue block61;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block61;
                }
                case "port_isolation": {
                    object.portIsolation(reader.readBoolean());
                    continue block61;
                }
                case "profile_required": {
                    object.profileRequired(reader.readBoolean());
                    continue block61;
                }
                case "qos": {
                    object.qos(XmlQosReader.readOne(reader));
                    continue block61;
                }
                case "required": {
                    object.required(reader.readBoolean());
                    continue block61;
                }
                case "status": {
                    object.status(XmlNetworkStatusReader.readOne(reader));
                    continue block61;
                }
                case "stp": {
                    object.stp(reader.readBoolean());
                    continue block61;
                }
                case "usages": {
                    object.usages(XmlNetworkUsageReader.readMany(reader));
                    continue block61;
                }
                case "vdsm_name": {
                    object.vdsmName(reader.readString());
                    continue block61;
                }
                case "vlan": {
                    object.vlan(XmlVlanReader.readOne(reader));
                    continue block61;
                }
                case "vnic_profiles": {
                    object.vnicProfiles(XmlVnicProfileReader.readMany(reader));
                    continue block61;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block61;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlNetworkReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Network> iterateMany(final XmlReader reader) {
        return new Iterator<Network>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Network next() {
                Network next = XmlNetworkReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Network> readMany(XmlReader reader) {
        ArrayList<Network> list = new ArrayList<Network>();
        Iterator<Network> iterator = XmlNetworkReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(NetworkContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "networklabels": {
                    ArrayListWithHref<NetworkLabel> list = new ArrayListWithHref<NetworkLabel>(object.networkLabels());
                    list.href(href);
                    object.networkLabels(list);
                    break;
                }
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "vnicprofiles": {
                    ArrayListWithHref<VnicProfile> list = new ArrayListWithHref<VnicProfile>(object.vnicProfiles());
                    list.href(href);
                    object.vnicProfiles(list);
                    break;
                }
            }
        }
    }
}

