/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RngSource {
    HWRNG("hwrng"),
    RANDOM("random"),
    URANDOM("urandom");

    private static final Logger log;
    private String image;

    private RngSource(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static RngSource fromValue(String value) {
        try {
            return RngSource.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'RngSource' enumerated type. Valid values are 'hwrng', 'random' and 'urandom'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(RngSource.class);
    }
}

