/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.NumaNodePin;
import org.ovirt.engine.sdk4.types.NumaTuneMode;
import org.ovirt.engine.sdk4.types.VirtualNumaNode;
import org.ovirt.engine.sdk4.types.Vm;

public class VirtualNumaNodeContainer extends NumaNodeContainer implements VirtualNumaNode {
    private List<NumaNodePin> numaNodePins;
    private NumaTuneMode numaTuneMode;
    private Vm vm;
    
    public List<NumaNodePin> numaNodePins() {
        return makeUnmodifiableList(numaNodePins);
    }
    
    public void numaNodePins(List<NumaNodePin> newNumaNodePins) {
        numaNodePins = makeArrayList(newNumaNodePins);
    }
    
    public boolean numaNodePinsPresent() {
        return numaNodePins != null && !numaNodePins.isEmpty();
    }
    
    public NumaTuneMode numaTuneMode() {
        return numaTuneMode;
    }
    
    public void numaTuneMode(NumaTuneMode newNumaTuneMode) {
        numaTuneMode = newNumaTuneMode;
    }
    
    public boolean numaTuneModePresent() {
        return numaTuneMode != null;
    }
    
    public Vm vm() {
        return vm;
    }
    
    public void vm(Vm newVm) {
        vm = newVm;
    }
    
    public boolean vmPresent() {
        return vm != null;
    }
    
}
