/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.InstanceTypeGraphicsConsolesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.InstanceTypeNicsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.InstanceTypeWatchdogsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeWriter;
import org.ovirt.engine.sdk4.services.InstanceTypeGraphicsConsolesService;
import org.ovirt.engine.sdk4.services.InstanceTypeNicsService;
import org.ovirt.engine.sdk4.services.InstanceTypeService;
import org.ovirt.engine.sdk4.services.InstanceTypeWatchdogsService;
import org.ovirt.engine.sdk4.types.InstanceType;

public class InstanceTypeServiceImpl
extends ServiceImpl
implements InstanceTypeService {
    public InstanceTypeServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public InstanceTypeService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public InstanceTypeService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public InstanceTypeService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public InstanceTypeGraphicsConsolesService graphicsConsolesService() {
        return new InstanceTypeGraphicsConsolesServiceImpl(this.getConnection(), this.getPath() + "/graphicsconsoles");
    }

    @Override
    public InstanceTypeNicsService nicsService() {
        return new InstanceTypeNicsServiceImpl(this.getConnection(), this.getPath() + "/nics");
    }

    @Override
    public InstanceTypeWatchdogsService watchdogsService() {
        return new InstanceTypeWatchdogsServiceImpl(this.getConnection(), this.getPath() + "/watchdogs");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("graphicsconsoles")) {
            return this.graphicsConsolesService();
        }
        if (path.startsWith("graphicsconsoles/")) {
            return this.graphicsConsolesService().service(path.substring(17));
        }
        if (path.equals("nics")) {
            return this.nicsService();
        }
        if (path.startsWith("nics/")) {
            return this.nicsService().service(path.substring(5));
        }
        if (path.equals("watchdogs")) {
            return this.watchdogsService();
        }
        if (path.startsWith("watchdogs/")) {
            return this.watchdogsService().service(path.substring(10));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "InstanceTypeService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements InstanceTypeService.UpdateResponse {
        private InstanceType instanceType;

        private UpdateResponseImpl() {
        }

        public void instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public InstanceType instanceType() {
            return this.instanceType;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<InstanceTypeService.UpdateRequest, InstanceTypeService.UpdateResponse>
    implements InstanceTypeService.UpdateRequest {
        private Boolean async;
        private InstanceType instanceType;

        private UpdateRequestImpl() {
        }

        @Override
        public InstanceTypeService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public InstanceTypeService.UpdateRequest instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public InstanceTypeService.UpdateRequest instanceType(InstanceTypeBuilder instanceType) {
            this.instanceType = instanceType.build();
            return this;
        }

        @Override
        public InstanceTypeService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypeServiceImpl.this.getConnection().getUrl() + InstanceTypeServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlInstanceTypeWriter.writeOne(this.instanceType, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.instanceType(XmlInstanceTypeReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            InstanceTypeServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements InstanceTypeService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<InstanceTypeService.RemoveRequest, InstanceTypeService.RemoveResponse>
    implements InstanceTypeService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public InstanceTypeService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public InstanceTypeService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypeServiceImpl.this.getConnection().getUrl() + InstanceTypeServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            InstanceTypeServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements InstanceTypeService.GetResponse {
        private InstanceType instanceType;

        private GetResponseImpl() {
        }

        public void instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public InstanceType instanceType() {
            return this.instanceType;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<InstanceTypeService.GetRequest, InstanceTypeService.GetResponse>
    implements InstanceTypeService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public InstanceTypeService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public InstanceTypeService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypeServiceImpl.this.getConnection().getUrl() + InstanceTypeServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.instanceType(XmlInstanceTypeReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            InstanceTypeServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

