/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.InstanceTypeServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeWriter;
import org.ovirt.engine.sdk4.services.InstanceTypeService;
import org.ovirt.engine.sdk4.services.InstanceTypesService;
import org.ovirt.engine.sdk4.types.InstanceType;

public class InstanceTypesServiceImpl
extends ServiceImpl
implements InstanceTypesService {
    public InstanceTypesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public InstanceTypesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public InstanceTypesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public InstanceTypeService instanceTypeService(String id) {
        return new InstanceTypeServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.instanceTypeService(path);
        }
        return this.instanceTypeService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "InstanceTypesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements InstanceTypesService.ListResponse {
        private List<InstanceType> instanceType;

        private ListResponseImpl() {
        }

        public void instanceType(List<InstanceType> instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public List<InstanceType> instanceType() {
            return this.instanceType;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<InstanceTypesService.ListRequest, InstanceTypesService.ListResponse>
    implements InstanceTypesService.ListRequest {
        private Boolean caseSensitive;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public InstanceTypesService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public InstanceTypesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public InstanceTypesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public InstanceTypesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public InstanceTypesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public InstanceTypesService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public InstanceTypesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypesServiceImpl.this.getConnection().getUrl() + InstanceTypesServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.instanceType(XmlInstanceTypeReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            InstanceTypesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements InstanceTypesService.AddResponse {
        private InstanceType instanceType;

        private AddResponseImpl() {
        }

        public void instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public InstanceType instanceType() {
            return this.instanceType;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<InstanceTypesService.AddRequest, InstanceTypesService.AddResponse>
    implements InstanceTypesService.AddRequest {
        private InstanceType instanceType;

        private AddRequestImpl() {
        }

        @Override
        public InstanceTypesService.AddRequest instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public InstanceTypesService.AddRequest instanceType(InstanceTypeBuilder instanceType) {
            this.instanceType = instanceType.build();
            return this;
        }

        @Override
        public InstanceTypesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypesServiceImpl.this.getConnection().getUrl() + InstanceTypesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlInstanceTypeWriter.writeOne(this.instanceType, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.instanceType(XmlInstanceTypeReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            InstanceTypesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

