/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HostStatus {
    CONNECTING("connecting"),
    DOWN("down"),
    ERROR("error"),
    INITIALIZING("initializing"),
    INSTALL_FAILED("install_failed"),
    INSTALLING("installing"),
    INSTALLING_OS("installing_os"),
    KDUMPING("kdumping"),
    MAINTENANCE("maintenance"),
    NON_OPERATIONAL("non_operational"),
    NON_RESPONSIVE("non_responsive"),
    PENDING_APPROVAL("pending_approval"),
    PREPARING_FOR_MAINTENANCE("preparing_for_maintenance"),
    REBOOT("reboot"),
    UNASSIGNED("unassigned"),
    UP("up");

    private static final Logger log;
    private String image;

    private HostStatus(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static HostStatus fromValue(String value) {
        try {
            return HostStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'HostStatus' enumerated type. Valid values are 'connecting', 'down', 'error', 'initializing', 'install_failed', 'installing', 'installing_os', 'kdumping', 'maintenance', 'non_operational', 'non_responsive', 'pending_approval', 'preparing_for_maintenance', 'reboot', 'unassigned' and 'up'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(HostStatus.class);
    }
}

