/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * When a direct LUN disk is using SCSI passthrough the privileged I/O policy is determined by this enum.
 */
public enum ScsiGenericIO {
    /**
     * Disable SCSI passthrough.
     */
    DISABLED("disabled"),
    /**
     * Disallow privileged SCSI I/O.
     */
    FILTERED("filtered"),
    /**
     * Allow privileged SCSI I/O.
     */
    UNFILTERED("unfiltered"),
    ;
    
    private static final Logger log = LoggerFactory.getLogger(ScsiGenericIO.class);
    
    private String image;
    
    ScsiGenericIO(String image) {
        this.image = image;
    }
    
    public String value() {
        return image;
    }
    
    public static ScsiGenericIO fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error(
            "The string '" + value + "' isn't a valid value for the 'ScsiGenericIO' enumerated type. " +
            "Valid values are 'disabled', 'filtered' and 'unfiltered'.",
            exception
            );
            return null;
        }
    }
    
}

