/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.WatchdogBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmWatchdogServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlWatchdogReader;
import org.ovirt.engine.sdk4.internal.xml.XmlWatchdogWriter;
import org.ovirt.engine.sdk4.services.VmWatchdogService;
import org.ovirt.engine.sdk4.services.VmWatchdogsService;
import org.ovirt.engine.sdk4.types.Watchdog;

public class VmWatchdogsServiceImpl
extends ServiceImpl
implements VmWatchdogsService {
    public VmWatchdogsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmWatchdogsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmWatchdogsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmWatchdogService watchdogService(String id) {
        return new VmWatchdogServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.watchdogService(path);
        }
        return this.watchdogService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmWatchdogsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmWatchdogsService.ListResponse {
        private List<Watchdog> watchdogs;

        private ListResponseImpl() {
        }

        public void watchdogs(List<Watchdog> watchdogs) {
            this.watchdogs = watchdogs;
        }

        @Override
        public List<Watchdog> watchdogs() {
            return this.watchdogs;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmWatchdogsService.ListRequest, VmWatchdogsService.ListResponse>
    implements VmWatchdogsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VmWatchdogsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmWatchdogsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmWatchdogsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmWatchdogsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmWatchdogsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmWatchdogsServiceImpl.this.getConnection().getUrl() + VmWatchdogsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmWatchdogsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.watchdogs(XmlWatchdogReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmWatchdogsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmWatchdogsService.AddResponse {
        private Watchdog watchdog;

        private AddResponseImpl() {
        }

        public void watchdog(Watchdog watchdog) {
            this.watchdog = watchdog;
        }

        @Override
        public Watchdog watchdog() {
            return this.watchdog;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmWatchdogsService.AddRequest, VmWatchdogsService.AddResponse>
    implements VmWatchdogsService.AddRequest {
        private Watchdog watchdog;

        private AddRequestImpl() {
        }

        @Override
        public VmWatchdogsService.AddRequest watchdog(Watchdog watchdog) {
            this.watchdog = watchdog;
            return this;
        }

        @Override
        public VmWatchdogsService.AddRequest watchdog(WatchdogBuilder watchdog) {
            this.watchdog = watchdog.build();
            return this;
        }

        @Override
        public VmWatchdogsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmWatchdogsServiceImpl.this.getConnection().getUrl() + VmWatchdogsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlWatchdogWriter.writeOne(this.watchdog, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmWatchdogsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.watchdog(XmlWatchdogReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmWatchdogsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

