/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.DiskContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskBackupModeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskBackupReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskContentTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskFormatReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskInterfaceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskSnapshotReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskStorageTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostStorageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQcowVersionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaReader;
import org.ovirt.engine.sdk4.internal.xml.XmlScsiGenericIOReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSnapshotReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskSnapshot;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlDiskReader {
    public static Disk readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        DiskContainer object = new DiskContainer();
        block98: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block98;
                }
                case "id": {
                    object.id(image);
                    continue block98;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block99: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "active": {
                    object.active(reader.readBoolean());
                    continue block99;
                }
                case "actual_size": {
                    object.actualSize(reader.readInteger());
                    continue block99;
                }
                case "alias": {
                    object.alias(reader.readString());
                    continue block99;
                }
                case "backup": {
                    object.backup(XmlDiskBackupReader.readOne(reader));
                    continue block99;
                }
                case "backup_mode": {
                    object.backupMode(XmlDiskBackupModeReader.readOne(reader));
                    continue block99;
                }
                case "bootable": {
                    object.bootable(reader.readBoolean());
                    continue block99;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block99;
                }
                case "content_type": {
                    object.contentType(XmlDiskContentTypeReader.readOne(reader));
                    continue block99;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block99;
                }
                case "disk_profile": {
                    object.diskProfile(XmlDiskProfileReader.readOne(reader));
                    continue block99;
                }
                case "disk_snapshots": {
                    object.diskSnapshots(XmlDiskSnapshotReader.readMany(reader));
                    continue block99;
                }
                case "external_disk": {
                    object.externalDisk(reader.readString());
                    continue block99;
                }
                case "format": {
                    object.format(XmlDiskFormatReader.readOne(reader));
                    continue block99;
                }
                case "image_id": {
                    object.imageId(reader.readString());
                    continue block99;
                }
                case "initial_size": {
                    object.initialSize(reader.readInteger());
                    continue block99;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block99;
                }
                case "interface": {
                    object.interface_(XmlDiskInterfaceReader.readOne(reader));
                    continue block99;
                }
                case "logical_name": {
                    object.logicalName(reader.readString());
                    continue block99;
                }
                case "lun_storage": {
                    object.lunStorage(XmlHostStorageReader.readOne(reader));
                    continue block99;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block99;
                }
                case "openstack_volume_type": {
                    object.openstackVolumeType(XmlOpenStackVolumeTypeReader.readOne(reader));
                    continue block99;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block99;
                }
                case "propagate_errors": {
                    object.propagateErrors(reader.readBoolean());
                    continue block99;
                }
                case "provisioned_size": {
                    object.provisionedSize(reader.readInteger());
                    continue block99;
                }
                case "qcow_version": {
                    object.qcowVersion(XmlQcowVersionReader.readOne(reader));
                    continue block99;
                }
                case "quota": {
                    object.quota(XmlQuotaReader.readOne(reader));
                    continue block99;
                }
                case "read_only": {
                    object.readOnly(reader.readBoolean());
                    continue block99;
                }
                case "sgio": {
                    object.sgio(XmlScsiGenericIOReader.readOne(reader));
                    continue block99;
                }
                case "shareable": {
                    object.shareable(reader.readBoolean());
                    continue block99;
                }
                case "snapshot": {
                    object.snapshot(XmlSnapshotReader.readOne(reader));
                    continue block99;
                }
                case "sparse": {
                    object.sparse(reader.readBoolean());
                    continue block99;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block99;
                }
                case "status": {
                    object.status(XmlDiskStatusReader.readOne(reader));
                    continue block99;
                }
                case "storage_domain": {
                    object.storageDomain(XmlStorageDomainReader.readOne(reader));
                    continue block99;
                }
                case "storage_domains": {
                    object.storageDomains(XmlStorageDomainReader.readMany(reader));
                    continue block99;
                }
                case "storage_type": {
                    object.storageType(XmlDiskStorageTypeReader.readOne(reader));
                    continue block99;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block99;
                }
                case "total_size": {
                    object.totalSize(reader.readInteger());
                    continue block99;
                }
                case "uses_scsi_reservation": {
                    object.usesScsiReservation(reader.readBoolean());
                    continue block99;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block99;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block99;
                }
                case "wipe_after_delete": {
                    object.wipeAfterDelete(reader.readBoolean());
                    continue block99;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block99;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlDiskReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Disk> iterateMany(final XmlReader reader) {
        return new Iterator<Disk>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Disk next() {
                Disk next = XmlDiskReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Disk> readMany(XmlReader reader) {
        ArrayList<Disk> list = new ArrayList<Disk>();
        Iterator<Disk> iterator = XmlDiskReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(DiskContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "disksnapshots": {
                    ArrayListWithHref<DiskSnapshot> list = new ArrayListWithHref<DiskSnapshot>(object.diskSnapshots());
                    list.href(href);
                    object.diskSnapshots(list);
                    break;
                }
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
                case "storagedomains": {
                    ArrayListWithHref<StorageDomain> list = new ArrayListWithHref<StorageDomain>(object.storageDomains());
                    list.href(href);
                    object.storageDomains(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

