#
# ovirt-host-deploy -- ovirt host deployer
# Copyright (C) 2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#


"""collectd packages plugin."""


import gettext


from otopi import plugin
from otopi import util


def _(m):
    return gettext.dgettext(message=m, domain='ovirt-host-deploy')


@util.export
class Plugin(plugin.PluginBase):
    """Required packages installation.
    """

    def __init__(self, context):
        super(Plugin, self).__init__(context=context)
        self._enabled = True

    @plugin.event(
        stage=plugin.Stages.STAGE_PACKAGES,
    )
    def _packages(self):
        try:
            self.packager.installUpdate((
                'collectd',
                'collectd-disk',
                'collectd-netlink',
                'collectd-virt',
                'collectd-write_http',
            ))
        except RuntimeError as e:
            self.logger.warning(
                _('Failed to install collectd packages: {e}').format(
                    e=e,
                )
            )
            self.logger.debug(
                'Failed to install collectd packages',
                exc_info=True,
            )

    # We do not configure collectd, so do not start it on closeup.
    # This is done separately later on.

# vim: expandtab tabstop=4 shiftwidth=4
