/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.cff;

public enum FieldType {
    FILLER(new char[]{'F', 'f'}, 0),
    SIZE_WITHOUT_HEADER(new char[]{'S', 's'}, 1),
    SIZE_WITH_HEADER(new char[]{'Z', 'z'}, 2),
    CHUNK_COUNT(new char[]{'C', 'c'}, 3),
    INTEGER_TYPE(new char[]{'M', 'm'}, 4),
    CHARACTER_TYPE(new char[]{'T', 't'}, 5),
    ID_NUMBER(new char[]{'N', 'n', 'I', 'i'}, 6),
    CHECKSUM(new char[]{'H', 'h'}, 14),
    DATA(new char[]{'d', 'D'}, 15);

    private char[] letters;
    private byte bitPattern;

    private FieldType(char[] letters, byte bitPattern) {
        this.letters = letters;
        this.bitPattern = bitPattern;
    }

    public static FieldType forChar(char letter) {
        FieldType[] fieldTypeArray = FieldType.values();
        int n = fieldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldType ft = fieldTypeArray[n2];
            char[] cArray = ft.letters;
            int n3 = ft.letters.length;
            int n4 = 0;
            while (n4 < n3) {
                char ch = cArray[n4];
                if (ch == letter) {
                    return ft;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static FieldType forBitPattern(byte bitPattern) {
        FieldType[] fieldTypeArray = FieldType.values();
        int n = fieldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldType ft = fieldTypeArray[n2];
            if ((ft.bitPattern & 0xF) == (bitPattern & 0xF)) {
                return ft;
            }
            ++n2;
        }
        return null;
    }

    public char[] allCharRepresentations() {
        return this.letters;
    }

    public char canonicalCharRepresentation() {
        return this.letters[0];
    }

    public byte bitPatternRepresentation() {
        return this.bitPattern;
    }
}

