{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetDataLength: Integer;
    procedure SetDataLength(const Value: Integer);
    function GetEncodingScheme: Integer;
    procedure SetEncodingScheme(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetNetworkMode: TDISNetworkMode;
    procedure SetNetworkMode(const Value: TDISNetworkMode);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
    function GetSampleRate: Integer;
    procedure SetSampleRate(const Value: Integer);
    function GetSamples: Integer;
    procedure SetSamples(const Value: Integer);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTdlType: Integer;
    procedure SetTdlType(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAddress: TSFString;
    { Internal wrapper for property @code(Address). This wrapper API may change, we advise to access simpler @code(Address) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAddress: TSFString read FFdAddress;
    {  }
    property Address: String read GetAddress write SetAddress;

    strict private FFdApplicationID: TSFInt32;
    { Internal wrapper for property @code(ApplicationID). This wrapper API may change, we advise to access simpler @code(ApplicationID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdApplicationID: TSFInt32 read FFdApplicationID;
    {  }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;

    strict private FFdData: TMFInt32;
    { Internal wrapper for property @code(Data). This wrapper API may change, we advise to access simpler @code(Data) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdData: TMFInt32 read FFdData;
    {  }
    procedure SetData(const Value: array of Int32); overload;
    {  }
    procedure SetData(const Value: TInt32List); overload;

    strict private FFdDataLength: TSFInt32;
    { Internal wrapper for property @code(DataLength). This wrapper API may change, we advise to access simpler @code(DataLength) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDataLength: TSFInt32 read FFdDataLength;
    {  }
    property DataLength: Integer read GetDataLength write SetDataLength;

    strict private FFdEncodingScheme: TSFInt32;
    { Internal wrapper for property @code(EncodingScheme). This wrapper API may change, we advise to access simpler @code(EncodingScheme) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEncodingScheme: TSFInt32 read FFdEncodingScheme;
    {  }
    property EncodingScheme: Integer read GetEncodingScheme write SetEncodingScheme;

    strict private FFdEntityID: TSFInt32;
    { Internal wrapper for property @code(EntityID). This wrapper API may change, we advise to access simpler @code(EntityID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityID: TSFInt32 read FFdEntityID;
    {  }
    property EntityID: Integer read GetEntityID write SetEntityID;

    strict private FFdMulticastRelayHost: TSFString;
    { Internal wrapper for property @code(MulticastRelayHost). This wrapper API may change, we advise to access simpler @code(MulticastRelayHost) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMulticastRelayHost: TSFString read FFdMulticastRelayHost;
    {  }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;

    strict private FFdMulticastRelayPort: TSFInt32;
    { Internal wrapper for property @code(MulticastRelayPort). This wrapper API may change, we advise to access simpler @code(MulticastRelayPort) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMulticastRelayPort: TSFInt32 read FFdMulticastRelayPort;
    {  }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;

    strict private FFdNetworkMode: TSFStringEnum;
    { Internal wrapper for property @code(NetworkMode). This wrapper API may change, we advise to access simpler @code(NetworkMode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNetworkMode: TSFStringEnum read FFdNetworkMode;
    {  }
    property NetworkMode: TDISNetworkMode read GetNetworkMode write SetNetworkMode;

    strict private FFdPort: TSFInt32;
    { Internal wrapper for property @code(Port). This wrapper API may change, we advise to access simpler @code(Port) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPort: TSFInt32 read FFdPort;
    {  }
    property Port: Integer read GetPort write SetPort;

    strict private FFdRadioID: TSFInt32;
    { Internal wrapper for property @code(RadioID). This wrapper API may change, we advise to access simpler @code(RadioID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioID: TSFInt32 read FFdRadioID;
    {  }
    property RadioID: Integer read GetRadioID write SetRadioID;

    strict private FFdReadInterval: TSFFloat;
    { Internal wrapper for property @code(ReadInterval). This wrapper API may change, we advise to access simpler @code(ReadInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReadInterval: TSFFloat read FFdReadInterval;
    {  }
    property ReadInterval: Single read GetReadInterval write SetReadInterval;

    strict private FFdRtpHeaderExpected: TSFBool;
    { Internal wrapper for property @code(RtpHeaderExpected). This wrapper API may change, we advise to access simpler @code(RtpHeaderExpected) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRtpHeaderExpected: TSFBool read FFdRtpHeaderExpected;
    {  }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;

    strict private FFdSampleRate: TSFInt32;
    { Internal wrapper for property @code(SampleRate). This wrapper API may change, we advise to access simpler @code(SampleRate) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSampleRate: TSFInt32 read FFdSampleRate;
    {  }
    property SampleRate: Integer read GetSampleRate write SetSampleRate;

    strict private FFdSamples: TSFInt32;
    { Internal wrapper for property @code(Samples). This wrapper API may change, we advise to access simpler @code(Samples) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSamples: TSFInt32 read FFdSamples;
    {  }
    property Samples: Integer read GetSamples write SetSamples;

    strict private FFdSiteID: TSFInt32;
    { Internal wrapper for property @code(SiteID). This wrapper API may change, we advise to access simpler @code(SiteID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSiteID: TSFInt32 read FFdSiteID;
    {  }
    property SiteID: Integer read GetSiteID write SetSiteID;

    strict private FFdTdlType: TSFInt32;
    { Internal wrapper for property @code(TdlType). This wrapper API may change, we advise to access simpler @code(TdlType) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTdlType: TSFInt32 read FFdTdlType;
    {  }
    property TdlType: Integer read GetTdlType write SetTdlType;

    strict private FFdWhichGeometry: TSFInt32;
    { Internal wrapper for property @code(WhichGeometry). This wrapper API may change, we advise to access simpler @code(WhichGeometry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWhichGeometry: TSFInt32 read FFdWhichGeometry;
    {  }
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;

    strict private FFdWriteInterval: TSFFloat;
    { Internal wrapper for property @code(WriteInterval). This wrapper API may change, we advise to access simpler @code(WriteInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWriteInterval: TSFFloat read FFdWriteInterval;
    {  }
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;

    strict private FEventIsNetworkReader: TSFBoolEvent;
    {  }
    public property EventIsNetworkReader: TSFBoolEvent read FEventIsNetworkReader;

    strict private FEventIsNetworkWriter: TSFBoolEvent;
    {  }
    public property EventIsNetworkWriter: TSFBoolEvent read FEventIsNetworkWriter;

    strict private FEventIsRtpHeaderHeard: TSFBoolEvent;
    {  }
    public property EventIsRtpHeaderHeard: TSFBoolEvent read FEventIsRtpHeaderHeard;

    strict private FEventIsStandAlone: TSFBoolEvent;
    {  }
    public property EventIsStandAlone: TSFBoolEvent read FEventIsStandAlone;

    strict private FEventTimestamp: TSFTimeEvent;
    {  }
    public property EventTimestamp: TSFTimeEvent read FEventTimestamp;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @code(BboxCenter). This wrapper API may change, we advise to access simpler @code(BboxCenter) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @code(BboxSize). This wrapper API may change, we advise to access simpler @code(BboxSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TSignalPduNode ----------------------------------------------- }

function TSignalPduNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TSignalPduNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TSignalPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TSignalPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

procedure TSignalPduNode.SetData(const Value: array of Int32);
begin
  FdData.Send(Value);
end;

procedure TSignalPduNode.SetData(const Value: TInt32List);
begin
  FdData.Send(Value);
end;

function TSignalPduNode.GetDataLength: Integer;
begin
  Result := FdDataLength.Value;
end;

procedure TSignalPduNode.SetDataLength(const Value: Integer);
begin
  FdDataLength.Send(Value);
end;

function TSignalPduNode.GetEncodingScheme: Integer;
begin
  Result := FdEncodingScheme.Value;
end;

procedure TSignalPduNode.SetEncodingScheme(const Value: Integer);
begin
  FdEncodingScheme.Send(Value);
end;

function TSignalPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TSignalPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TSignalPduNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TSignalPduNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TSignalPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TSignalPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TSignalPduNode.GetNetworkMode: TDISNetworkMode;
begin
  Result := TDISNetworkMode(FdNetworkMode.EnumValue);
end;

procedure TSignalPduNode.SetNetworkMode(const Value: TDISNetworkMode);
begin
  FdNetworkMode.SendEnumValue(Ord(Value));
end;

function TSignalPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TSignalPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TSignalPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TSignalPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TSignalPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TSignalPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TSignalPduNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TSignalPduNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TSignalPduNode.GetSampleRate: Integer;
begin
  Result := FdSampleRate.Value;
end;

procedure TSignalPduNode.SetSampleRate(const Value: Integer);
begin
  FdSampleRate.Send(Value);
end;

function TSignalPduNode.GetSamples: Integer;
begin
  Result := FdSamples.Value;
end;

procedure TSignalPduNode.SetSamples(const Value: Integer);
begin
  FdSamples.Send(Value);
end;

function TSignalPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TSignalPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TSignalPduNode.GetTdlType: Integer;
begin
  Result := FdTdlType.Value;
end;

procedure TSignalPduNode.SetTdlType(const Value: Integer);
begin
  FdTdlType.Send(Value);
end;

function TSignalPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TSignalPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TSignalPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TSignalPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TSignalPduNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TSignalPduNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function TSignalPduNode.ClassX3DType: String;
begin
  Result := 'SignalPdu';
end;

procedure TSignalPduNode.CreateNode;
begin
  inherited;

  FFdAddress := TSFString.Create(Self, True, 'address', 'localhost');
   FdAddress.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAddress);

  FFdApplicationID := TSFInt32.Create(Self, True, 'applicationID', 1);
   FdApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdApplicationID);

  FFdData := TMFInt32.Create(Self, True, 'data', []);
   FdData.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdData);

  FFdDataLength := TSFInt32.Create(Self, True, 'dataLength', 0);
   FdDataLength.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDataLength);

  FFdEncodingScheme := TSFInt32.Create(Self, True, 'encodingScheme', 0);
   FdEncodingScheme.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEncodingScheme);

  FFdEntityID := TSFInt32.Create(Self, True, 'entityID', 0);
   FdEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityID);

  FFdMulticastRelayHost := TSFString.Create(Self, True, 'multicastRelayHost', '');
   FdMulticastRelayHost.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayHost);

  FFdMulticastRelayPort := TSFInt32.Create(Self, True, 'multicastRelayPort', 0);
   FdMulticastRelayPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayPort);

  FFdNetworkMode := TSFStringEnum.Create(Self, True, 'networkMode', @DISNetworkModeNames, Ord(High(DISNetworkModeNames)) + 1, Ord(nmStandAlone));
   FdNetworkMode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNetworkMode);

  FFdPort := TSFInt32.Create(Self, True, 'port', 0);
   FdPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPort);

  FFdRadioID := TSFInt32.Create(Self, True, 'radioID', 0);
   FdRadioID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioID);

  FFdReadInterval := TSFFloat.Create(Self, True, 'readInterval', 0.1);
   FdReadInterval.ChangeAlways := chVisibleNonGeometry;
   FdReadInterval.MustBeNonnegative := true;
  AddField(FFdReadInterval);

  FFdRtpHeaderExpected := TSFBool.Create(Self, True, 'rtpHeaderExpected', false);
   FdRtpHeaderExpected.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRtpHeaderExpected);

  FFdSampleRate := TSFInt32.Create(Self, True, 'sampleRate', 0);
   FdSampleRate.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSampleRate);

  FFdSamples := TSFInt32.Create(Self, True, 'samples', 0);
   FdSamples.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSamples);

  FFdSiteID := TSFInt32.Create(Self, True, 'siteID', 0);
   FdSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSiteID);

  FFdTdlType := TSFInt32.Create(Self, True, 'tdlType', 0);
   FdTdlType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTdlType);

  FFdWhichGeometry := TSFInt32.Create(Self, True, 'whichGeometry', 1);
   FdWhichGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWhichGeometry);

  FFdWriteInterval := TSFFloat.Create(Self, True, 'writeInterval', 1.0);
   FdWriteInterval.ChangeAlways := chVisibleNonGeometry;
   FdWriteInterval.MustBeNonnegative := true;
  AddField(FFdWriteInterval);

  FEventIsNetworkReader := TSFBoolEvent.Create(Self, 'isNetworkReader', false);
  AddEvent(FEventIsNetworkReader);

  FEventIsNetworkWriter := TSFBoolEvent.Create(Self, 'isNetworkWriter', false);
  AddEvent(FEventIsNetworkWriter);

  FEventIsRtpHeaderHeard := TSFBoolEvent.Create(Self, 'isRtpHeaderHeard', false);
  AddEvent(FEventIsRtpHeaderHeard);

  FEventIsStandAlone := TSFBoolEvent.Create(Self, 'isStandAlone', false);
  AddEvent(FEventIsStandAlone);

  FEventTimestamp := TSFTimeEvent.Create(Self, 'timestamp', false);
  AddEvent(FEventTimestamp);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
