;;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:          package.lisp
;;;; Purpose:       Package file for cl-pubmed
;;;; Programmer:    Kevin M. Rosenberg
;;;; Date Started:  Jun 2001
;;;;
;;;; $Id: package.lisp 9010 2004-04-15 06:47:23Z kevin $
;;;;
;;;; This file, part of cl-pubmed, is Copyright (c) 2002 by Kevin M. Rosenberg
;;;;
;;;; cl-pubmed users are granted the rights to distribute and use this software
;;;; as governed by the terms of the GNU Lesser General Public License 
;;;; (http://www.gnu.org/licenses/lgpl.html)
;;;; *************************************************************************

(in-package #:cl-user)

(defpackage #:pubmed
  (:use #:common-lisp #:kmrcl)
  (:export

   ;; Conditions
   #:pubmed-condition
   #:pubmed-query-error
   #:pubmed-server-error
   #:pubmed-condition-response
   
   ;; Query functions
   #:pm-query
   #:pm-fetch-ids

   ;; Print functions
   #:print-article
   #:print-article-set

   ; Classes
   #:pm-article
   #:pm-article-set

   ;; pm-article-set accessors 
   #:articles
   #:articles-query
   #:articles-total
   #:articles-count
   #:articles-start

   ;; article accessors
   #:article-pmid
   #:article-title
   #:article-authors
   #:article-affiliation
   #:article-journal
   #:article-date
   #:article-volume
   #:article-issue
   #:article-pages
   #:article-abstract
   #:article-mesh-headings

   ;; proxy setting
   #:*proxy-host*
   ))
