# frozen_string_literal: true

class PrepareIndexVulnerabilityOccurrencePipelinesOnProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.3'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_occurrence_pipelines_on_project_id'

  def up
    # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
    prepare_async_index :vulnerability_occurrence_pipelines, :project_id, name: INDEX_NAME
    # rubocop:enable Migration/PreventIndexCreation
  end

  def down
    unprepare_async_index :vulnerability_occurrence_pipelines, INDEX_NAME
  end
end
