#!/bin/bash

source "$(dirname "${BASH_SOURCE}")/lib/init.sh"

SCRIPT_ROOT=$(dirname "${BASH_SOURCE}")/..
TMP_ROOT="${SCRIPT_ROOT}/_tmp"

cleanup() {
  rm -rf "${TMP_ROOT}"
}
trap "cleanup" EXIT SIGINT

cleanup

for gv in ${API_GROUP_VERSIONS}; do
  mkdir -p "${TMP_ROOT}/${gv}"
  cp -a "${SCRIPT_ROOT}/${gv}"/* "${TMP_ROOT}/${gv}"
done

"${SCRIPT_ROOT}/hack/update-protobuf.sh"
echo "Checking against freshly generated protobuf..."
for gv in ${API_GROUP_VERSIONS}; do
  ret=0
  diff -Naupr -I 'Auto generated by' -x 'zz_generated.*' -x 'types_swagger*' "${SCRIPT_ROOT}/${gv}" "${TMP_ROOT}/${gv}" || ret=$?
  if [[ $ret -ne 0 ]]; then
    cp -a "${TMP_ROOT}"/* "${SCRIPT_ROOT}/"
    echo "Protobuf is out of date. Please run hack/update-protobuf.sh"
    exit 1
  fi
done
echo "Protobuf up to date."
