#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Copyright 2020 Daniel Estevez <daniel@destevez.net>
#
# This file is part of gr-satellites
#
# SPDX-License-Identifier: GPL-3.0-or-later
#

from satellites.satyaml import yamlfiles

def rest_transmitters(trans):
    print('  Transmitters:')
    print()
    for name, data in trans.items():
        print(f"    * **{name}** ({data['frequency']*1e-6:.3f} MHz): {data['modulation']} modulation with {data['framing']} framing")

def rest_satyaml(satyaml):
    print(f"**{satyaml['name']}**")
    if satyaml.get('alternative_names'):
        print('  Alternative names: ', end = '')
        print(', '.join(satyaml.get('alternative_names')))
        print()
    print(f"  NORAD ID: {satyaml['norad']}")
    print()
    rest_transmitters(satyaml['transmitters'])
    print()
        
def main():
    print('.. _Supported satellites:')
    print()
    print('Supported satellites')
    print('====================')
    print()
    print("""This is a list of all the satellites supported by gr-satellites.
The list is auto-generated by reading the SatYAML files and using the script ``docs/generate_supported_satellites.py``.
""")
    print()
    
    ymls = yamlfiles.load_all_yaml()
    for yml in sorted(ymls, key = lambda x: x['name'].casefold()):
        rest_satyaml(yml)

if __name__ == '__main__':
    main()
