## Highlights


- Added support for config directory and config snippets and reload on SIGHUP
- Improved debug logging/tracing
- Actually implemented the docuemnted krb5_principal option
- Numerous bugfixes


## Detailed Changelog

Lukas Slebodnik (1):

- BUILD: Include gp_rpc_debug.h into tarball


Robbie Harwood (24):

- Extract generalized selinux context comparison function
- Ensure ini_config >= 1.2.0 for `ini_config_augment()`
- Fix formatting on noncompliant copyright lines
- Allow configdir and configfile to be specified together
- getpwman(3) can return NULL without setting errno
- Reload config on SIGHUP
- Use pkg-config to find libgssapi-krb5.so*
- Correct handling of EINTR on read()/write()
- Port test suite to python3
- Add tests for reloading on SIGHUP
- Log useful message on kernel interface failure
- Clear message structure before decoding into it
- Fix potential deadlock on socket grab
- Fix possible explicit NULL deref in gpm_accept_sec_context
- Fix several leaks
- Set C standard used to gnu99
- Fix for gss_inquire_attrs_for_mech accepting NULLs
- Specify KRB5RCACHEDIR in systemd unit file
- Allow symbolic euids in conf files
- Remove one layer of abstraction over dinglibs
- Add support for config directories
- Update man pages for symbolic euids and config snippets
- Error on `allow_any_uid` issues
- Add HTTP service and move NFS into its own conf file


Roland Mainz (3):

- Turn on strict aliasing rules
- Remove support for iniparse library
- Update BUILD.txt


Simo Sorce (23):

- Fix make clean
- Fix const warning in gp_creds.c
- Fix const warning that can lead to issues
- Improve code in gp_export_gssx_cred()
- Add options to specify a debug level
- Add higher level debugging for all rpc calls
- Add helper to find options in rpc messages
- Add gss_acquire_cred_impersonate_name support
- Add helpers to store and retrieve encrypted creds
- Fix acquiring default credentials
- Add acquire test and generally improve tests
- Use t_utils.h in all tests.
- Appropriately resolve const warnings in tests.
- Add impersonate test
- Better naming for tests log files
- Always use valgrind for gssproxy tests
- Since krb5 1.14 inquire_context may return no name
- Fix crash bug when reconfiguring service
- Fix use after free bug 
- Implement the krb5_principal option
- Add test to verify krb5_principal works
- Allow to specify a client name for init tests
- Release version 0.5.0


