; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+experimental-zvfh,+v \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+experimental-zvfh,+v \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV64

declare <vscale x 1 x i8> @llvm.vp.gather.nxv1i8.nxv1p0i8(<vscale x 1 x i8*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @vpgather_nxv1i8(<vscale x 1 x i8*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <vscale x 1 x i8> @llvm.vp.gather.nxv1i8.nxv1p0i8(<vscale x 1 x i8*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i8> %v
}

declare <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i8> @vpgather_nxv2i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i8> %v
}

define <vscale x 2 x i16> @vpgather_nxv2i8_sextload_nxv2i16(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8_sextload_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV32-NEXT:    vsext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8_sextload_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV64-NEXT:    vsext.vf2 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %ev
}

define <vscale x 2 x i16> @vpgather_nxv2i8_zextload_nxv2i16(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8_zextload_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV32-NEXT:    vzext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8_zextload_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV64-NEXT:    vzext.vf2 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = zext <vscale x 2 x i8> %v to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %ev
}

define <vscale x 2 x i32> @vpgather_nxv2i8_sextload_nxv2i32(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8_sextload_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32-NEXT:    vsext.vf4 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8_sextload_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64-NEXT:    vsext.vf4 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = sext <vscale x 2 x i8> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %ev
}

define <vscale x 2 x i32> @vpgather_nxv2i8_zextload_nxv2i32(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8_zextload_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32-NEXT:    vzext.vf4 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8_zextload_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64-NEXT:    vzext.vf4 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = zext <vscale x 2 x i8> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %ev
}

define <vscale x 2 x i64> @vpgather_nxv2i8_sextload_nxv2i64(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8_sextload_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vsext.vf8 v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8_sextload_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vsext.vf8 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = sext <vscale x 2 x i8> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ev
}

define <vscale x 2 x i64> @vpgather_nxv2i8_zextload_nxv2i64(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i8_zextload_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vzext.vf8 v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i8_zextload_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vzext.vf8 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.gather.nxv2i8.nxv2p0i8(<vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = zext <vscale x 2 x i8> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ev
}

declare <vscale x 4 x i8> @llvm.vp.gather.nxv4i8.nxv4p0i8(<vscale x 4 x i8*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i8> @vpgather_nxv4i8(<vscale x 4 x i8*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v12
; RV64-NEXT:    ret
  %v = call <vscale x 4 x i8> @llvm.vp.gather.nxv4i8.nxv4p0i8(<vscale x 4 x i8*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i8> %v
}

define <vscale x 4 x i8> @vpgather_truemask_nxv4i8(<vscale x 4 x i8*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8
; RV32-NEXT:    vmv1r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8
; RV64-NEXT:    vmv1r.v v8, v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i8> @llvm.vp.gather.nxv4i8.nxv4p0i8(<vscale x 4 x i8*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x i8> %v
}

declare <vscale x 8 x i8> @llvm.vp.gather.nxv8i8.nxv8p0i8(<vscale x 8 x i8*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i8> @vpgather_nxv8i8(<vscale x 8 x i8*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; RV64-NEXT:    vluxei64.v v16, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v16
; RV64-NEXT:    ret
  %v = call <vscale x 8 x i8> @llvm.vp.gather.nxv8i8.nxv8p0i8(<vscale x 8 x i8*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i8> %v
}

define <vscale x 8 x i8> @vpgather_baseidx_nxv8i8(i8* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x i8> @llvm.vp.gather.nxv8i8.nxv8p0i8(<vscale x 8 x i8*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i8> %v
}

declare <vscale x 32 x i8> @llvm.vp.gather.nxv32i8.nxv32p0i8(<vscale x 32 x i8*>, <vscale x 32 x i1>, i32)

define <vscale x 32 x i8> @vpgather_baseidx_nxv32i8(i8* %base, <vscale x 32 x i8> %idxs, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv32i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v12, v0
; RV32-NEXT:    li a3, 0
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    srli a5, a2, 2
; RV32-NEXT:    vsetvli a4, zero, e8, mf2, ta, mu
; RV32-NEXT:    slli a2, a2, 1
; RV32-NEXT:    sub a4, a1, a2
; RV32-NEXT:    vslidedown.vx v0, v0, a5
; RV32-NEXT:    bltu a1, a4, .LBB12_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a3, a4
; RV32-NEXT:  .LBB12_2:
; RV32-NEXT:    vsetvli a4, zero, e32, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v24, v10
; RV32-NEXT:    vsetvli zero, a3, e8, m2, ta, mu
; RV32-NEXT:    vluxei32.v v18, (a0), v24, v0.t
; RV32-NEXT:    bltu a1, a2, .LBB12_4
; RV32-NEXT:  # %bb.3:
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:  .LBB12_4:
; RV32-NEXT:    vsetvli a2, zero, e32, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v24, v8
; RV32-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; RV32-NEXT:    vmv1r.v v0, v12
; RV32-NEXT:    vluxei32.v v16, (a0), v24, v0.t
; RV32-NEXT:    vmv4r.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv32i8:
; RV64:       # %bb.0:
; RV64-NEXT:    csrr a3, vlenb
; RV64-NEXT:    slli a5, a3, 1
; RV64-NEXT:    sub a6, a1, a5
; RV64-NEXT:    vmv1r.v v12, v0
; RV64-NEXT:    li a4, 0
; RV64-NEXT:    li a2, 0
; RV64-NEXT:    bltu a1, a6, .LBB12_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a6
; RV64-NEXT:  .LBB12_2:
; RV64-NEXT:    sub a6, a2, a3
; RV64-NEXT:    mv a7, a4
; RV64-NEXT:    bltu a2, a6, .LBB12_4
; RV64-NEXT:  # %bb.3:
; RV64-NEXT:    mv a7, a6
; RV64-NEXT:  .LBB12_4:
; RV64-NEXT:    srli a6, a3, 2
; RV64-NEXT:    vsetvli t0, zero, e8, mf2, ta, mu
; RV64-NEXT:    vslidedown.vx v13, v12, a6
; RV64-NEXT:    srli a6, a3, 3
; RV64-NEXT:    vsetvli t0, zero, e8, mf4, ta, mu
; RV64-NEXT:    vslidedown.vx v0, v13, a6
; RV64-NEXT:    vsetvli t0, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v24, v11
; RV64-NEXT:    vsetvli zero, a7, e8, m1, ta, mu
; RV64-NEXT:    vluxei64.v v19, (a0), v24, v0.t
; RV64-NEXT:    bltu a1, a5, .LBB12_6
; RV64-NEXT:  # %bb.5:
; RV64-NEXT:    mv a1, a5
; RV64-NEXT:  .LBB12_6:
; RV64-NEXT:    sub a5, a1, a3
; RV64-NEXT:    bltu a1, a5, .LBB12_8
; RV64-NEXT:  # %bb.7:
; RV64-NEXT:    mv a4, a5
; RV64-NEXT:  .LBB12_8:
; RV64-NEXT:    vsetvli a5, zero, e8, mf4, ta, mu
; RV64-NEXT:    vslidedown.vx v0, v12, a6
; RV64-NEXT:    vsetvli a5, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v24, v9
; RV64-NEXT:    vsetvli zero, a4, e8, m1, ta, mu
; RV64-NEXT:    vluxei64.v v17, (a0), v24, v0.t
; RV64-NEXT:    bltu a1, a3, .LBB12_10
; RV64-NEXT:  # %bb.9:
; RV64-NEXT:    mv a1, a3
; RV64-NEXT:  .LBB12_10:
; RV64-NEXT:    vsetvli a4, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v24, v8
; RV64-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; RV64-NEXT:    vmv1r.v v0, v12
; RV64-NEXT:    vluxei64.v v16, (a0), v24, v0.t
; RV64-NEXT:    bltu a2, a3, .LBB12_12
; RV64-NEXT:  # %bb.11:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB12_12:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v24, v10
; RV64-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; RV64-NEXT:    vmv1r.v v0, v13
; RV64-NEXT:    vluxei64.v v18, (a0), v24, v0.t
; RV64-NEXT:    vmv4r.v v8, v16
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <vscale x 32 x i8> %idxs
  %v = call <vscale x 32 x i8> @llvm.vp.gather.nxv32i8.nxv32p0i8(<vscale x 32 x i8*> %ptrs, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i8> %v
}

declare <vscale x 1 x i16> @llvm.vp.gather.nxv1i16.nxv1p0i16(<vscale x 1 x i16*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i16> @vpgather_nxv1i16(<vscale x 1 x i16*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <vscale x 1 x i16> @llvm.vp.gather.nxv1i16.nxv1p0i16(<vscale x 1 x i16*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}

declare <vscale x 2 x i16> @llvm.vp.gather.nxv2i16.nxv2p0i16(<vscale x 2 x i16*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i16> @vpgather_nxv2i16(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.gather.nxv2i16.nxv2p0i16(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}

define <vscale x 2 x i32> @vpgather_nxv2i16_sextload_nxv2i32(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i16_sextload_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32-NEXT:    vsext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i16_sextload_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64-NEXT:    vsext.vf2 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.gather.nxv2i16.nxv2p0i16(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = sext <vscale x 2 x i16> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %ev
}

define <vscale x 2 x i32> @vpgather_nxv2i16_zextload_nxv2i32(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i16_zextload_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32-NEXT:    vzext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i16_zextload_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64-NEXT:    vzext.vf2 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.gather.nxv2i16.nxv2p0i16(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = zext <vscale x 2 x i16> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %ev
}

define <vscale x 2 x i64> @vpgather_nxv2i16_sextload_nxv2i64(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i16_sextload_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i16_sextload_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vsext.vf4 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.gather.nxv2i16.nxv2p0i16(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = sext <vscale x 2 x i16> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ev
}

define <vscale x 2 x i64> @vpgather_nxv2i16_zextload_nxv2i64(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i16_zextload_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i16_zextload_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vzext.vf4 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.gather.nxv2i16.nxv2p0i16(<vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = zext <vscale x 2 x i16> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ev
}

declare <vscale x 4 x i16> @llvm.vp.gather.nxv4i16.nxv4p0i16(<vscale x 4 x i16*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @vpgather_nxv4i16(<vscale x 4 x i16*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.vp.gather.nxv4i16.nxv4p0i16(<vscale x 4 x i16*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}

define <vscale x 4 x i16> @vpgather_truemask_nxv4i16(<vscale x 4 x i16*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i16> @llvm.vp.gather.nxv4i16.nxv4p0i16(<vscale x 4 x i16*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x i16> %v
}

declare <vscale x 8 x i16> @llvm.vp.gather.nxv8i16.nxv8p0i16(<vscale x 8 x i16*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i16> @vpgather_nxv8i16(<vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v16, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v16
; RV64-NEXT:    ret
  %v = call <vscale x 8 x i16> @llvm.vp.gather.nxv8i16.nxv8p0i16(<vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vpgather_baseidx_nxv8i8_nxv8i16(i16* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x i16> @llvm.vp.gather.nxv8i16.nxv8p0i16(<vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vpgather_baseidx_sext_nxv8i8_nxv8i16(i16* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i16> %eidxs
  %v = call <vscale x 8 x i16> @llvm.vp.gather.nxv8i16.nxv8p0i16(<vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vpgather_baseidx_zext_nxv8i8_nxv8i16(i16* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i16> %eidxs
  %v = call <vscale x 8 x i16> @llvm.vp.gather.nxv8i16.nxv8p0i16(<vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vpgather_baseidx_nxv8i16(i16* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i16> %idxs
  %v = call <vscale x 8 x i16> @llvm.vp.gather.nxv8i16.nxv8p0i16(<vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

declare <vscale x 1 x i32> @llvm.vp.gather.nxv1i32.nxv1p0i32(<vscale x 1 x i32*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i32> @vpgather_nxv1i32(<vscale x 1 x i32*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <vscale x 1 x i32> @llvm.vp.gather.nxv1i32.nxv1p0i32(<vscale x 1 x i32*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}

declare <vscale x 2 x i32> @llvm.vp.gather.nxv2i32.nxv2p0i32(<vscale x 2 x i32*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @vpgather_nxv2i32(<vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.vp.gather.nxv2i32.nxv2p0i32(<vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i64> @vpgather_nxv2i32_sextload_nxv2i64(<vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i32_sextload_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i32_sextload_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vsext.vf2 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.vp.gather.nxv2i32.nxv2p0i32(<vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = sext <vscale x 2 x i32> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ev
}

define <vscale x 2 x i64> @vpgather_nxv2i32_zextload_nxv2i64(<vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i32_zextload_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vzext.vf2 v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i32_zextload_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vzext.vf2 v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.vp.gather.nxv2i32.nxv2p0i32(<vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  %ev = zext <vscale x 2 x i32> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ev
}

declare <vscale x 4 x i32> @llvm.vp.gather.nxv4i32.nxv4p0i32(<vscale x 4 x i32*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i32> @vpgather_nxv4i32(<vscale x 4 x i32*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %v = call <vscale x 4 x i32> @llvm.vp.gather.nxv4i32.nxv4p0i32(<vscale x 4 x i32*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}

define <vscale x 4 x i32> @vpgather_truemask_nxv4i32(<vscale x 4 x i32*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i32> @llvm.vp.gather.nxv4i32.nxv4p0i32(<vscale x 4 x i32*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x i32> %v
}

declare <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i32> @vpgather_nxv8i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v16, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v16
; RV64-NEXT:    ret
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_nxv8i8_nxv8i32(i32* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_sext_nxv8i8_nxv8i32(i32* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_zext_nxv8i8_nxv8i32(i32* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_nxv8i16_nxv8i32(i32* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i16> %idxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_sext_nxv8i16_nxv8i32(i32* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_zext_nxv8i16_nxv8i32(i32* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vpgather_baseidx_nxv8i32(i32* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %idxs
  %v = call <vscale x 8 x i32> @llvm.vp.gather.nxv8i32.nxv8p0i32(<vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

declare <vscale x 1 x i64> @llvm.vp.gather.nxv1i64.nxv1p0i64(<vscale x 1 x i64*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i64> @vpgather_nxv1i64(<vscale x 1 x i64*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.vp.gather.nxv1i64.nxv1p0i64(<vscale x 1 x i64*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}

declare <vscale x 2 x i64> @llvm.vp.gather.nxv2i64.nxv2p0i64(<vscale x 2 x i64*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i64> @vpgather_nxv2i64(<vscale x 2 x i64*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.vp.gather.nxv2i64.nxv2p0i64(<vscale x 2 x i64*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}

declare <vscale x 4 x i64> @llvm.vp.gather.nxv4i64.nxv4p0i64(<vscale x 4 x i64*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i64> @vpgather_nxv4i64(<vscale x 4 x i64*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 4 x i64> @llvm.vp.gather.nxv4i64.nxv4p0i64(<vscale x 4 x i64*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}

define <vscale x 4 x i64> @vpgather_truemask_nxv4i64(<vscale x 4 x i64*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i64> @llvm.vp.gather.nxv4i64.nxv4p0i64(<vscale x 4 x i64*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x i64> %v
}

declare <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i64> @vpgather_nxv8i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_nxv8i8_nxv8i64(i64* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v16, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_sext_nxv8i8_nxv8i64(i64* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf8 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_zext_nxv8i8_nxv8i64(i64* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf8 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_nxv8i16_nxv8i64(i64* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i16_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v16, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i16_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i16> %idxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_sext_nxv8i16_nxv8i64(i64* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_zext_nxv8i16_nxv8i64(i64* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_nxv8i32_nxv8i64(i64* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i32_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v16, v8, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i32_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i32> %idxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_sext_nxv8i32_nxv8i64(i64* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i32_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i32_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_zext_nxv8i32_nxv8i64(i64* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i32_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i32_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vpgather_baseidx_nxv8i64(i64* %base, <vscale x 8 x i64> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsll.vi v8, v8, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsll.vi v8, v8, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %idxs
  %v = call <vscale x 8 x i64> @llvm.vp.gather.nxv8i64.nxv8p0i64(<vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

declare <vscale x 1 x half> @llvm.vp.gather.nxv1f16.nxv1p0f16(<vscale x 1 x half*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x half> @vpgather_nxv1f16(<vscale x 1 x half*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <vscale x 1 x half> @llvm.vp.gather.nxv1f16.nxv1p0f16(<vscale x 1 x half*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x half> %v
}

declare <vscale x 2 x half> @llvm.vp.gather.nxv2f16.nxv2p0f16(<vscale x 2 x half*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x half> @vpgather_nxv2f16(<vscale x 2 x half*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.vp.gather.nxv2f16.nxv2p0f16(<vscale x 2 x half*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x half> %v
}

declare <vscale x 4 x half> @llvm.vp.gather.nxv4f16.nxv4p0f16(<vscale x 4 x half*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x half> @vpgather_nxv4f16(<vscale x 4 x half*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %v = call <vscale x 4 x half> @llvm.vp.gather.nxv4f16.nxv4p0f16(<vscale x 4 x half*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x half> %v
}

define <vscale x 4 x half> @vpgather_truemask_nxv4f16(<vscale x 4 x half*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x half> @llvm.vp.gather.nxv4f16.nxv4p0f16(<vscale x 4 x half*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x half> %v
}

declare <vscale x 8 x half> @llvm.vp.gather.nxv8f16.nxv8p0f16(<vscale x 8 x half*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x half> @vpgather_nxv8f16(<vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v16, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v16
; RV64-NEXT:    ret
  %v = call <vscale x 8 x half> @llvm.vp.gather.nxv8f16.nxv8p0f16(<vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

define <vscale x 8 x half> @vpgather_baseidx_nxv8i8_nxv8f16(half* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x half> @llvm.vp.gather.nxv8f16.nxv8p0f16(<vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

define <vscale x 8 x half> @vpgather_baseidx_sext_nxv8i8_nxv8f16(half* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i16> %eidxs
  %v = call <vscale x 8 x half> @llvm.vp.gather.nxv8f16.nxv8p0f16(<vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

define <vscale x 8 x half> @vpgather_baseidx_zext_nxv8i8_nxv8f16(half* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i16> %eidxs
  %v = call <vscale x 8 x half> @llvm.vp.gather.nxv8f16.nxv8p0f16(<vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

define <vscale x 8 x half> @vpgather_baseidx_nxv8f16(half* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i16> %idxs
  %v = call <vscale x 8 x half> @llvm.vp.gather.nxv8f16.nxv8p0f16(<vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

declare <vscale x 1 x float> @llvm.vp.gather.nxv1f32.nxv1p0f32(<vscale x 1 x float*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x float> @vpgather_nxv1f32(<vscale x 1 x float*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <vscale x 1 x float> @llvm.vp.gather.nxv1f32.nxv1p0f32(<vscale x 1 x float*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x float> %v
}

declare <vscale x 2 x float> @llvm.vp.gather.nxv2f32.nxv2p0f32(<vscale x 2 x float*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x float> @vpgather_nxv2f32(<vscale x 2 x float*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v10
; RV64-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.vp.gather.nxv2f32.nxv2p0f32(<vscale x 2 x float*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x float> %v
}

declare <vscale x 4 x float> @llvm.vp.gather.nxv4f32.nxv4p0f32(<vscale x 4 x float*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x float> @vpgather_nxv4f32(<vscale x 4 x float*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %v = call <vscale x 4 x float> @llvm.vp.gather.nxv4f32.nxv4p0f32(<vscale x 4 x float*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x float> %v
}

define <vscale x 4 x float> @vpgather_truemask_nxv4f32(<vscale x 4 x float*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8
; RV64-NEXT:    vmv.v.v v8, v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x float> @llvm.vp.gather.nxv4f32.nxv4p0f32(<vscale x 4 x float*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x float> %v
}

declare <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x float> @vpgather_nxv8f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v16, (zero), v8, v0.t
; RV64-NEXT:    vmv.v.v v8, v16
; RV64-NEXT:    ret
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_nxv8i8_nxv8f32(float* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_sext_nxv8i8_nxv8f32(float* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_zext_nxv8i8_nxv8f32(float* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_nxv8i16_nxv8f32(float* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i16_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i16_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i16> %idxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_sext_nxv8i16_nxv8f32(float* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_zext_nxv8i16_nxv8f32(float* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v8, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vpgather_baseidx_nxv8f32(float* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %idxs
  %v = call <vscale x 8 x float> @llvm.vp.gather.nxv8f32.nxv8p0f32(<vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

declare <vscale x 1 x double> @llvm.vp.gather.nxv1f64.nxv1p0f64(<vscale x 1 x double*>, <vscale x 1 x i1>, i32)

define <vscale x 1 x double> @vpgather_nxv1f64(<vscale x 1 x double*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv1f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.vp.gather.nxv1f64.nxv1p0f64(<vscale x 1 x double*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x double> %v
}

declare <vscale x 2 x double> @llvm.vp.gather.nxv2f64.nxv2p0f64(<vscale x 2 x double*>, <vscale x 2 x i1>, i32)

define <vscale x 2 x double> @vpgather_nxv2f64(<vscale x 2 x double*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 2 x double> @llvm.vp.gather.nxv2f64.nxv2p0f64(<vscale x 2 x double*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x double> %v
}

declare <vscale x 4 x double> @llvm.vp.gather.nxv4f64.nxv4p0f64(<vscale x 4 x double*>, <vscale x 4 x i1>, i32)

define <vscale x 4 x double> @vpgather_nxv4f64(<vscale x 4 x double*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 4 x double> @llvm.vp.gather.nxv4f64.nxv4p0f64(<vscale x 4 x double*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x double> %v
}

define <vscale x 4 x double> @vpgather_truemask_nxv4f64(<vscale x 4 x double*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpgather_truemask_nxv4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_truemask_nxv4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x double> @llvm.vp.gather.nxv4f64.nxv4p0f64(<vscale x 4 x double*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret <vscale x 4 x double> %v
}

declare <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*>, <vscale x 6 x i1>, i32)

define <vscale x 6 x double> @vpgather_nxv6f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_nxv6i8_nxv6f64(double* %base, <vscale x 6 x i8> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv6i8_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v16, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv6i8_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i8> %idxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_sext_nxv6i8_nxv6f64(double* %base, <vscale x 6 x i8> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv6i8_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf8 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv6i8_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 6 x i8> %idxs to <vscale x 6 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %eidxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_zext_nxv6i8_nxv6f64(double* %base, <vscale x 6 x i8> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv6i8_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf8 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv6i8_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 6 x i8> %idxs to <vscale x 6 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %eidxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_nxv6i16_nxv6f64(double* %base, <vscale x 6 x i16> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv6i16_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v16, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv6i16_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i16> %idxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_sext_nxv6i16_nxv6f64(double* %base, <vscale x 6 x i16> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv6i16_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv6i16_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 6 x i16> %idxs to <vscale x 6 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %eidxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_zext_nxv6i16_nxv6f64(double* %base, <vscale x 6 x i16> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv6i16_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv6i16_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 6 x i16> %idxs to <vscale x 6 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %eidxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_nxv6i32_nxv6f64(double* %base, <vscale x 6 x i32> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv6i32_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v16, v8, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv6i32_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i32> %idxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_sext_nxv6i32_nxv6f64(double* %base, <vscale x 6 x i32> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv6i32_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv6i32_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 6 x i32> %idxs to <vscale x 6 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %eidxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_zext_nxv6i32_nxv6f64(double* %base, <vscale x 6 x i32> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv6i32_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv6i32_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 6 x i32> %idxs to <vscale x 6 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %eidxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

define <vscale x 6 x double> @vpgather_baseidx_nxv6f64(double* %base, <vscale x 6 x i64> %idxs, <vscale x 6 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv6f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsll.vi v8, v8, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv6f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsll.vi v8, v8, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 6 x i64> %idxs
  %v = call <vscale x 6 x double> @llvm.vp.gather.nxv6f64.nxv6p0f64(<vscale x 6 x double*> %ptrs, <vscale x 6 x i1> %m, i32 %evl)
  ret <vscale x 6 x double> %v
}

declare <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*>, <vscale x 8 x i1>, i32)

define <vscale x 8 x double> @vpgather_nxv8f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_nxv8i8_nxv8f64(double* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i8_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v8
; RV32-NEXT:    vsll.vi v16, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i8_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i8> %idxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_sext_nxv8i8_nxv8f64(double* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf8 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i8_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_zext_nxv8i8_nxv8f64(double* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf8 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i8_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_nxv8i16_nxv8f64(double* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i16_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v8
; RV32-NEXT:    vsll.vi v16, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i16_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i16> %idxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_sext_nxv8i16_nxv8f64(double* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i16_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_zext_nxv8i16_nxv8f64(double* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i16_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_nxv8i32_nxv8f64(double* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8i32_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v16, v8, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8i32_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i32> %idxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_sext_nxv8i32_nxv8f64(double* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv8i32_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv8i32_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_zext_nxv8i32_nxv8f64(double* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv8i32_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv8i32_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf2 v16, v8
; RV64-NEXT:    vsll.vi v8, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vpgather_baseidx_nxv8f64(double* %base, <vscale x 8 x i64> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    vsll.vi v8, v8, 3
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsll.vi v8, v8, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v8, (a0), v8, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %idxs
  %v = call <vscale x 8 x double> @llvm.vp.gather.nxv8f64.nxv8p0f64(<vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

declare <vscale x 16 x double> @llvm.vp.gather.nxv16f64.nxv16p0f64(<vscale x 16 x double*>, <vscale x 16 x i1>, i32)

define <vscale x 16 x double> @vpgather_nxv16f64(<vscale x 16 x double*> %ptrs, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_nxv16f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v24, v0
; RV32-NEXT:    li a2, 0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    srli a4, a1, 3
; RV32-NEXT:    vsetvli a3, zero, e8, mf4, ta, mu
; RV32-NEXT:    sub a3, a0, a1
; RV32-NEXT:    vslidedown.vx v0, v0, a4
; RV32-NEXT:    bltu a0, a3, .LBB102_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB102_2:
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (zero), v12, v0.t
; RV32-NEXT:    bltu a0, a1, .LBB102_4
; RV32-NEXT:  # %bb.3:
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:  .LBB102_4:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV32-NEXT:    vmv1r.v v0, v24
; RV32-NEXT:    vluxei32.v v24, (zero), v8, v0.t
; RV32-NEXT:    vmv.v.v v8, v24
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_nxv16f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v24, v0
; RV64-NEXT:    li a2, 0
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    srli a4, a1, 3
; RV64-NEXT:    vsetvli a3, zero, e8, mf4, ta, mu
; RV64-NEXT:    sub a3, a0, a1
; RV64-NEXT:    vslidedown.vx v0, v0, a4
; RV64-NEXT:    bltu a0, a3, .LBB102_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB102_2:
; RV64-NEXT:    vsetvli zero, a2, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v16, (zero), v16, v0.t
; RV64-NEXT:    bltu a0, a1, .LBB102_4
; RV64-NEXT:  # %bb.3:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:  .LBB102_4:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV64-NEXT:    vmv1r.v v0, v24
; RV64-NEXT:    vluxei64.v v8, (zero), v8, v0.t
; RV64-NEXT:    ret
  %v = call <vscale x 16 x double> @llvm.vp.gather.nxv16f64.nxv16p0f64(<vscale x 16 x double*> %ptrs, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x double> %v
}

define <vscale x 16 x double> @vpgather_baseidx_nxv16i16_nxv16f64(double* %base, <vscale x 16 x i16> %idxs, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_nxv16i16_nxv16f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v12, v0
; RV32-NEXT:    li a3, 0
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    srli a5, a2, 3
; RV32-NEXT:    vsetvli a4, zero, e8, mf4, ta, mu
; RV32-NEXT:    sub a4, a1, a2
; RV32-NEXT:    vslidedown.vx v0, v0, a5
; RV32-NEXT:    bltu a1, a4, .LBB103_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a3, a4
; RV32-NEXT:  .LBB103_2:
; RV32-NEXT:    vsetvli a4, zero, e32, m8, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v8
; RV32-NEXT:    vsll.vi v24, v16, 3
; RV32-NEXT:    vsetvli zero, a3, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (a0), v28, v0.t
; RV32-NEXT:    bltu a1, a2, .LBB103_4
; RV32-NEXT:  # %bb.3:
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:  .LBB103_4:
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vmv1r.v v0, v12
; RV32-NEXT:    vluxei32.v v8, (a0), v24, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_nxv16i16_nxv16f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v12, v0
; RV64-NEXT:    li a3, 0
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    srli a5, a2, 3
; RV64-NEXT:    vsetvli a4, zero, e8, mf4, ta, mu
; RV64-NEXT:    sub a4, a1, a2
; RV64-NEXT:    vslidedown.vx v0, v0, a5
; RV64-NEXT:    bltu a1, a4, .LBB103_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a3, a4
; RV64-NEXT:  .LBB103_2:
; RV64-NEXT:    vsetvli a4, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v10
; RV64-NEXT:    vsll.vi v16, v16, 3
; RV64-NEXT:    vsetvli zero, a3, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v16, (a0), v16, v0.t
; RV64-NEXT:    bltu a1, a2, .LBB103_4
; RV64-NEXT:  # %bb.3:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB103_4:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v24, v8
; RV64-NEXT:    vsll.vi v24, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vmv1r.v v0, v12
; RV64-NEXT:    vluxei64.v v8, (a0), v24, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 16 x i16> %idxs
  %v = call <vscale x 16 x double> @llvm.vp.gather.nxv16f64.nxv16p0f64(<vscale x 16 x double*> %ptrs, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x double> %v
}

define <vscale x 16 x double> @vpgather_baseidx_sext_nxv16i16_nxv16f64(double* %base, <vscale x 16 x i16> %idxs, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_sext_nxv16i16_nxv16f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    vsext.vf4 v16, v8
; RV32-NEXT:    mv a3, a1
; RV32-NEXT:    bltu a1, a2, .LBB104_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a3, a2
; RV32-NEXT:  .LBB104_2:
; RV32-NEXT:    li a4, 0
; RV32-NEXT:    vsext.vf4 v24, v10
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a3, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    srli a3, a2, 3
; RV32-NEXT:    vsetvli a5, zero, e8, mf4, ta, mu
; RV32-NEXT:    sub a2, a1, a2
; RV32-NEXT:    vslidedown.vx v0, v0, a3
; RV32-NEXT:    bltu a1, a2, .LBB104_4
; RV32-NEXT:  # %bb.3:
; RV32-NEXT:    mv a4, a2
; RV32-NEXT:  .LBB104_4:
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV32-NEXT:    vsll.vi v16, v24, 3
; RV32-NEXT:    vsetvli zero, a4, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v24, v16
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (a0), v24, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_sext_nxv16i16_nxv16f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v12, v0
; RV64-NEXT:    li a3, 0
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v10
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    srli a5, a2, 3
; RV64-NEXT:    vsetvli a4, zero, e8, mf4, ta, mu
; RV64-NEXT:    sub a4, a1, a2
; RV64-NEXT:    vslidedown.vx v0, v0, a5
; RV64-NEXT:    bltu a1, a4, .LBB104_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a3, a4
; RV64-NEXT:  .LBB104_2:
; RV64-NEXT:    vsetvli a4, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v24, v8
; RV64-NEXT:    vsll.vi v16, v16, 3
; RV64-NEXT:    vsetvli zero, a3, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v16, (a0), v16, v0.t
; RV64-NEXT:    bltu a1, a2, .LBB104_4
; RV64-NEXT:  # %bb.3:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB104_4:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsll.vi v24, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vmv1r.v v0, v12
; RV64-NEXT:    vluxei64.v v8, (a0), v24, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 16 x i16> %idxs to <vscale x 16 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 16 x i64> %eidxs
  %v = call <vscale x 16 x double> @llvm.vp.gather.nxv16f64.nxv16p0f64(<vscale x 16 x double*> %ptrs, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x double> %v
}

define <vscale x 16 x double> @vpgather_baseidx_zext_nxv16i16_nxv16f64(double* %base, <vscale x 16 x i16> %idxs, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpgather_baseidx_zext_nxv16i16_nxv16f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    vzext.vf4 v16, v8
; RV32-NEXT:    mv a3, a1
; RV32-NEXT:    bltu a1, a2, .LBB105_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a3, a2
; RV32-NEXT:  .LBB105_2:
; RV32-NEXT:    li a4, 0
; RV32-NEXT:    vzext.vf4 v24, v10
; RV32-NEXT:    vsll.vi v8, v16, 3
; RV32-NEXT:    vsetvli zero, a3, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v16, v8
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    srli a3, a2, 3
; RV32-NEXT:    vsetvli a5, zero, e8, mf4, ta, mu
; RV32-NEXT:    sub a2, a1, a2
; RV32-NEXT:    vslidedown.vx v0, v0, a3
; RV32-NEXT:    bltu a1, a2, .LBB105_4
; RV32-NEXT:  # %bb.3:
; RV32-NEXT:    mv a4, a2
; RV32-NEXT:  .LBB105_4:
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV32-NEXT:    vsll.vi v16, v24, 3
; RV32-NEXT:    vsetvli zero, a4, e32, m4, ta, mu
; RV32-NEXT:    vncvt.x.x.w v24, v16
; RV32-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32-NEXT:    vluxei32.v v16, (a0), v24, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpgather_baseidx_zext_nxv16i16_nxv16f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v12, v0
; RV64-NEXT:    li a3, 0
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v10
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    srli a5, a2, 3
; RV64-NEXT:    vsetvli a4, zero, e8, mf4, ta, mu
; RV64-NEXT:    sub a4, a1, a2
; RV64-NEXT:    vslidedown.vx v0, v0, a5
; RV64-NEXT:    bltu a1, a4, .LBB105_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a3, a4
; RV64-NEXT:  .LBB105_2:
; RV64-NEXT:    vsetvli a4, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v24, v8
; RV64-NEXT:    vsll.vi v16, v16, 3
; RV64-NEXT:    vsetvli zero, a3, e64, m8, ta, mu
; RV64-NEXT:    vluxei64.v v16, (a0), v16, v0.t
; RV64-NEXT:    bltu a1, a2, .LBB105_4
; RV64-NEXT:  # %bb.3:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB105_4:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsll.vi v24, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vmv1r.v v0, v12
; RV64-NEXT:    vluxei64.v v8, (a0), v24, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 16 x i16> %idxs to <vscale x 16 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 16 x i64> %eidxs
  %v = call <vscale x 16 x double> @llvm.vp.gather.nxv16f64.nxv16p0f64(<vscale x 16 x double*> %ptrs, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x double> %v
}
