// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -show-encoding %s | FileCheck --check-prefix=GFX10 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX10 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 %s 2>&1 | FileCheck --check-prefix=GFX10-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=GFX10-ERR --implicit-check-not=error: %s

//===----------------------------------------------------------------------===//
// ENC_VOP1.
//===----------------------------------------------------------------------===//

v_nop_e32
// GFX10: encoding: [0x00,0x00,0x00,0x7e]

v_nop_e64
// GFX10: encoding: [0x00,0x00,0x80,0xd5,0x00,0x00,0x00,0x00]

v_mov_b32_e32 v5, v1
// GFX10: encoding: [0x01,0x03,0x0a,0x7e]

v_mov_b32_e32 v255, v1
// GFX10: encoding: [0x01,0x03,0xfe,0x7f]

v_mov_b32_e32 v5, v255
// GFX10: encoding: [0xff,0x03,0x0a,0x7e]

v_mov_b32_e32 v5, s1
// GFX10: encoding: [0x01,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, s103
// GFX10: encoding: [0x67,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, m0
// GFX10: encoding: [0x7c,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, 0
// GFX10: encoding: [0x80,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, -1
// GFX10: encoding: [0xc1,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x02,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_mov_b32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x02,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_mov_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x81,0xd5,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xff,0x01,0x00,0x00]

v_mov_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x01,0x00,0x00,0x00]

v_mov_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x65,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x6a,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x6b,0x00,0x00,0x00]

v_mov_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x7c,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x7e,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x7f,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x80,0x00,0x00,0x00]

v_mov_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xc1,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xf0,0x00,0x00,0x00]

v_mov_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xf7,0x00,0x00,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_mov_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_mov_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_mov_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_mov_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_mov_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_mov_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_mov_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_mov_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_mov_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_mov_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_mov_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_mov_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_mov_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_mov_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_mov_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_mov_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_mov_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_readfirstlane_b32 s5, v1
// GFX10: encoding: [0x01,0x05,0x0a,0x7e]

v_readfirstlane_b32 s103, v1
// GFX10: encoding: [0x01,0x05,0xce,0x7e]

v_readfirstlane_b32 ttmp11, v1
// GFX10: encoding: [0x01,0x05,0xee,0x7e]

v_readfirstlane_b32 s5, v255
// GFX10: encoding: [0xff,0x05,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, v[1:2]
// GFX10: encoding: [0x01,0x07,0x0a,0x7e]

v_cvt_i32_f64_e32 v255, v[1:2]
// GFX10: encoding: [0x01,0x07,0xfe,0x7f]

v_cvt_i32_f64_e32 v5, v[254:255]
// GFX10: encoding: [0xfe,0x07,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, s[2:3]
// GFX10: encoding: [0x02,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, s[4:5]
// GFX10: encoding: [0x04,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, s[102:103]
// GFX10: encoding: [0x66,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, vcc
// GFX10: encoding: [0x6a,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, exec
// GFX10: encoding: [0x7e,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, 0
// GFX10: encoding: [0x80,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, -1
// GFX10: encoding: [0xc1,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x06,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f64_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x06,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x02,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x04,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x64,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x80,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x01,0x01,0x00,0x20]

v_cvt_i32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[4:5] mul:2
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x04,0x00,0x00,0x08]

v_cvt_i32_f64_e64 v5, v[1:2] clamp div:2
// GFX10: encoding: [0x05,0x80,0x83,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f64_i32_e32 v[5:6], v1
// GFX10: encoding: [0x01,0x09,0x0a,0x7e]

v_cvt_f64_i32_e32 v[254:255], v1
// GFX10: encoding: [0x01,0x09,0xfc,0x7f]

v_cvt_f64_i32_e32 v[5:6], v255
// GFX10: encoding: [0xff,0x09,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], s1
// GFX10: encoding: [0x01,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], s103
// GFX10: encoding: [0x67,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], vcc_lo
// GFX10: encoding: [0x6a,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], vcc_hi
// GFX10: encoding: [0x6b,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], ttmp11
// GFX10: encoding: [0x77,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], m0
// GFX10: encoding: [0x7c,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], exec_lo
// GFX10: encoding: [0x7e,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], exec_hi
// GFX10: encoding: [0x7f,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], 0
// GFX10: encoding: [0x80,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], -1
// GFX10: encoding: [0xc1,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x08,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_i32_e32 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x08,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_i32_e64 v[5:6], v1
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[254:255], v1
// GFX10: encoding: [0xfe,0x00,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v255
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s101
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_lo
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_hi
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], m0
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_lo
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_hi
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 clamp
// GFX10: encoding: [0x05,0x80,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 mul:2
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], v1 mul:4
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f64_i32_e64 v[5:6], v1 div:2
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_i32_e32 v5, v1
// GFX10: encoding: [0x01,0x0b,0x0a,0x7e]

v_cvt_f32_i32_e32 v255, v1
// GFX10: encoding: [0x01,0x0b,0xfe,0x7f]

v_cvt_f32_i32_e32 v5, v255
// GFX10: encoding: [0xff,0x0b,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, s1
// GFX10: encoding: [0x01,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, s103
// GFX10: encoding: [0x67,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, m0
// GFX10: encoding: [0x7c,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, 0
// GFX10: encoding: [0x80,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, -1
// GFX10: encoding: [0xc1,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x0a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_i32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x0a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_i32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_i32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_i32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_i32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_i32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_i32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_u32_e32 v5, v1
// GFX10: encoding: [0x01,0x0d,0x0a,0x7e]

v_cvt_f32_u32_e32 v255, v1
// GFX10: encoding: [0x01,0x0d,0xfe,0x7f]

v_cvt_f32_u32_e32 v5, v255
// GFX10: encoding: [0xff,0x0d,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, s1
// GFX10: encoding: [0x01,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, s103
// GFX10: encoding: [0x67,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, m0
// GFX10: encoding: [0x7c,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, 0
// GFX10: encoding: [0x80,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, -1
// GFX10: encoding: [0xc1,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x0c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_u32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x0c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_u32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_u32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_u32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_u32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_u32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_u32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_u32_f32_e32 v5, v1
// GFX10: encoding: [0x01,0x0f,0x0a,0x7e]

v_cvt_u32_f32_e32 v255, v1
// GFX10: encoding: [0x01,0x0f,0xfe,0x7f]

v_cvt_u32_f32_e32 v5, v255
// GFX10: encoding: [0xff,0x0f,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, s1
// GFX10: encoding: [0x01,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, s103
// GFX10: encoding: [0x67,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, m0
// GFX10: encoding: [0x7c,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, 0
// GFX10: encoding: [0x80,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, -1
// GFX10: encoding: [0xc1,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x0e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x0e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x65,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x80,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x01,0x00,0x20]

v_cvt_u32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1 mul:2
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x00,0x00,0x08]

v_cvt_u32_f32_e64 v5, v1 clamp div:2
// GFX10: encoding: [0x05,0x80,0x87,0xd5,0x01,0x01,0x00,0x18]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_u32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_u32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_u32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_i32_f32_e32 v5, v1
// GFX10: encoding: [0x01,0x11,0x0a,0x7e]

v_cvt_i32_f32_e32 v255, v1
// GFX10: encoding: [0x01,0x11,0xfe,0x7f]

v_cvt_i32_f32_e32 v5, v255
// GFX10: encoding: [0xff,0x11,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, s1
// GFX10: encoding: [0x01,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, s103
// GFX10: encoding: [0x67,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, m0
// GFX10: encoding: [0x7c,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, 0
// GFX10: encoding: [0x80,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, -1
// GFX10: encoding: [0xc1,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x10,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x10,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x65,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x80,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x01,0x00,0x20]

v_cvt_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x01,0x00,0x08]

v_cvt_i32_f32_e64 v5, v1 clamp div:2
// GFX10: encoding: [0x05,0x80,0x88,0xd5,0x01,0x01,0x00,0x18]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f16_f32 v5, v1
// GFX10: encoding: [0x01,0x15,0x0a,0x7e]

v_cvt_f16_f32 v255, v1
// GFX10: encoding: [0x01,0x15,0xfe,0x7f]

v_cvt_f16_f32 v5, v255
// GFX10: encoding: [0xff,0x15,0x0a,0x7e]

v_cvt_f16_f32 v5, s1
// GFX10: encoding: [0x01,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, s103
// GFX10: encoding: [0x67,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, m0
// GFX10: encoding: [0x7c,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0
// GFX10: encoding: [0x80,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -1
// GFX10: encoding: [0xc1,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x14,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x14,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f16_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f16_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f16_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f16_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_f16_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f16_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_f16 v5, v1
// GFX10: encoding: [0x01,0x17,0x0a,0x7e]

v_cvt_f32_f16 v255, v1
// GFX10: encoding: [0x01,0x17,0xfe,0x7f]

v_cvt_f32_f16 v5, v255
// GFX10: encoding: [0xff,0x17,0x0a,0x7e]

v_cvt_f32_f16 v5, s1
// GFX10: encoding: [0x01,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, s103
// GFX10: encoding: [0x67,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_lo
// GFX10: encoding: [0x6a,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_hi
// GFX10: encoding: [0x6b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, ttmp11
// GFX10: encoding: [0x77,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, m0
// GFX10: encoding: [0x7c,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_lo
// GFX10: encoding: [0x7e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_hi
// GFX10: encoding: [0x7f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0
// GFX10: encoding: [0x80,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, -1
// GFX10: encoding: [0xc1,0x16,0x0a,0x7e]

v_cvt_f32_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f32_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_f16_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_f16_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_f32_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_rpi_i32_f32 v5, v1
// GFX10: encoding: [0x01,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v255, v1
// GFX10: encoding: [0x01,0x19,0xfe,0x7f]

v_cvt_rpi_i32_f32 v5, v255
// GFX10: encoding: [0xff,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s1
// GFX10: encoding: [0x01,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s103
// GFX10: encoding: [0x67,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, m0
// GFX10: encoding: [0x7c,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0
// GFX10: encoding: [0x80,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -1
// GFX10: encoding: [0xc1,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x18,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_rpi_i32_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x18,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_rpi_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xff,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x01,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x65,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x80,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x01,0x01,0x00,0x20]

v_cvt_rpi_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_rpi_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_rpi_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_flr_i32_f32 v5, v1
// GFX10: encoding: [0x01,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v255, v1
// GFX10: encoding: [0x01,0x1b,0xfe,0x7f]

v_cvt_flr_i32_f32 v5, v255
// GFX10: encoding: [0xff,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s1
// GFX10: encoding: [0x01,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s103
// GFX10: encoding: [0x67,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, m0
// GFX10: encoding: [0x7c,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0
// GFX10: encoding: [0x80,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -1
// GFX10: encoding: [0xc1,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x1a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_flr_i32_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x1a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_flr_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xff,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x01,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x65,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x80,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x01,0x01,0x00,0x20]

v_cvt_flr_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_flr_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_flr_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_off_f32_i4 v5, v1
// GFX10: encoding: [0x01,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v255, v1
// GFX10: encoding: [0x01,0x1d,0xfe,0x7f]

v_cvt_off_f32_i4 v5, v255
// GFX10: encoding: [0xff,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s1
// GFX10: encoding: [0x01,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s103
// GFX10: encoding: [0x67,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_lo
// GFX10: encoding: [0x6a,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_hi
// GFX10: encoding: [0x6b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, ttmp11
// GFX10: encoding: [0x77,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, m0
// GFX10: encoding: [0x7c,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_lo
// GFX10: encoding: [0x7e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_hi
// GFX10: encoding: [0x7f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0
// GFX10: encoding: [0x80,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -1
// GFX10: encoding: [0xc1,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0.5
// GFX10: encoding: [0xf0,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -4.0
// GFX10: encoding: [0xf7,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0x4f
// GFX10: encoding: [0xff,0x1c,0x0a,0x7e,0x4f,0x00,0x00,0x00]

v_cvt_off_f32_i4 v5, 0x41
// GFX10: encoding: [0xff,0x1c,0x0a,0x7e,0x41,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xff,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x65,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x80,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x10]

v_cvt_off_f32_i4_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x18]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_off_f32_i4_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_f64 v5, v[1:2]
// GFX10: encoding: [0x01,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v255, v[1:2]
// GFX10: encoding: [0x01,0x1f,0xfe,0x7f]

v_cvt_f32_f64 v5, v[254:255]
// GFX10: encoding: [0xfe,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v5, s[2:3]
// GFX10: encoding: [0x02,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[4:5]
// GFX10: encoding: [0x04,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[102:103]
// GFX10: encoding: [0x66,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, vcc
// GFX10: encoding: [0x6a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, exec
// GFX10: encoding: [0x7e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0
// GFX10: encoding: [0x80,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -1
// GFX10: encoding: [0xc1,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0.5
// GFX10: encoding: [0xf0,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -4.0
// GFX10: encoding: [0xf7,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0xaf123456
// GFX10: encoding: [0xff,0x1e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_f64 v5, 0x3f717273
// GFX10: encoding: [0xff,0x1e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x02,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x04,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x64,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_f64_e64 v5, v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_f64_e64 v5, v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f64_f32 v[5:6], v1
// GFX10: encoding: [0x01,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[254:255], v1
// GFX10: encoding: [0x01,0x21,0xfc,0x7f]

v_cvt_f64_f32 v[5:6], v255
// GFX10: encoding: [0xff,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s1
// GFX10: encoding: [0x01,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s103
// GFX10: encoding: [0x67,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_lo
// GFX10: encoding: [0x6a,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_hi
// GFX10: encoding: [0x6b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], ttmp11
// GFX10: encoding: [0x77,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], m0
// GFX10: encoding: [0x7c,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_lo
// GFX10: encoding: [0x7e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_hi
// GFX10: encoding: [0x7f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0
// GFX10: encoding: [0x80,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -1
// GFX10: encoding: [0xc1,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x20,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_f32 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x20,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_f32_e64 v[5:6], v1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[254:255], v1
// GFX10: encoding: [0xfe,0x00,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v255
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s101
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_lo
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_hi
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], m0
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_lo
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_hi
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -v1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f64_f32_e64 v[5:6], |v1|
// GFX10: encoding: [0x05,0x01,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 clamp
// GFX10: encoding: [0x05,0x80,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 mul:2
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f64_f32_e64 v[5:6], v1 mul:4
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f64_f32_e64 v[5:6], v1 div:2
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0 v5, v1
// GFX10: encoding: [0x01,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v255, v1
// GFX10: encoding: [0x01,0x23,0xfe,0x7f]

v_cvt_f32_ubyte0 v5, v255
// GFX10: encoding: [0xff,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s1
// GFX10: encoding: [0x01,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s103
// GFX10: encoding: [0x67,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_lo
// GFX10: encoding: [0x6a,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_hi
// GFX10: encoding: [0x6b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, ttmp11
// GFX10: encoding: [0x77,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, m0
// GFX10: encoding: [0x7c,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_lo
// GFX10: encoding: [0x7e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_hi
// GFX10: encoding: [0x7f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0
// GFX10: encoding: [0x80,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -1
// GFX10: encoding: [0xc1,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0.5
// GFX10: encoding: [0xf0,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -4.0
// GFX10: encoding: [0xf7,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0xaf123456
// GFX10: encoding: [0xff,0x22,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte0 v5, 0x3f717273
// GFX10: encoding: [0xff,0x22,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte0_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte0_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte0_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte0_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_ubyte1 v5, v1
// GFX10: encoding: [0x01,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v255, v1
// GFX10: encoding: [0x01,0x25,0xfe,0x7f]

v_cvt_f32_ubyte1 v5, v255
// GFX10: encoding: [0xff,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s1
// GFX10: encoding: [0x01,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s103
// GFX10: encoding: [0x67,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_lo
// GFX10: encoding: [0x6a,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_hi
// GFX10: encoding: [0x6b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, ttmp11
// GFX10: encoding: [0x77,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, m0
// GFX10: encoding: [0x7c,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_lo
// GFX10: encoding: [0x7e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_hi
// GFX10: encoding: [0x7f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0
// GFX10: encoding: [0x80,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -1
// GFX10: encoding: [0xc1,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0.5
// GFX10: encoding: [0xf0,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -4.0
// GFX10: encoding: [0xf7,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0xaf123456
// GFX10: encoding: [0xff,0x24,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte1 v5, 0x3f717273
// GFX10: encoding: [0xff,0x24,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte1_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte1_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte1_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte1_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_ubyte2 v5, v1
// GFX10: encoding: [0x01,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v255, v1
// GFX10: encoding: [0x01,0x27,0xfe,0x7f]

v_cvt_f32_ubyte2 v5, v255
// GFX10: encoding: [0xff,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s1
// GFX10: encoding: [0x01,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s103
// GFX10: encoding: [0x67,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_lo
// GFX10: encoding: [0x6a,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_hi
// GFX10: encoding: [0x6b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, ttmp11
// GFX10: encoding: [0x77,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, m0
// GFX10: encoding: [0x7c,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_lo
// GFX10: encoding: [0x7e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_hi
// GFX10: encoding: [0x7f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0
// GFX10: encoding: [0x80,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -1
// GFX10: encoding: [0xc1,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0.5
// GFX10: encoding: [0xf0,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -4.0
// GFX10: encoding: [0xf7,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0xaf123456
// GFX10: encoding: [0xff,0x26,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte2 v5, 0x3f717273
// GFX10: encoding: [0xff,0x26,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte2_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte2_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte2_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte2_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_ubyte3 v5, v1
// GFX10: encoding: [0x01,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v255, v1
// GFX10: encoding: [0x01,0x29,0xfe,0x7f]

v_cvt_f32_ubyte3 v5, v255
// GFX10: encoding: [0xff,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s1
// GFX10: encoding: [0x01,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s103
// GFX10: encoding: [0x67,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_lo
// GFX10: encoding: [0x6a,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_hi
// GFX10: encoding: [0x6b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, ttmp11
// GFX10: encoding: [0x77,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, m0
// GFX10: encoding: [0x7c,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_lo
// GFX10: encoding: [0x7e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_hi
// GFX10: encoding: [0x7f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0
// GFX10: encoding: [0x80,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -1
// GFX10: encoding: [0xc1,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0.5
// GFX10: encoding: [0xf0,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -4.0
// GFX10: encoding: [0xf7,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0xaf123456
// GFX10: encoding: [0xff,0x28,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte3 v5, 0x3f717273
// GFX10: encoding: [0xff,0x28,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte3_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte3_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte3_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte3_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_u32_f64 v5, v[1:2]
// GFX10: encoding: [0x01,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v255, v[1:2]
// GFX10: encoding: [0x01,0x2b,0xfe,0x7f]

v_cvt_u32_f64 v5, v[254:255]
// GFX10: encoding: [0xfe,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v5, s[2:3]
// GFX10: encoding: [0x02,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[4:5]
// GFX10: encoding: [0x04,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[102:103]
// GFX10: encoding: [0x66,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, vcc
// GFX10: encoding: [0x6a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, exec
// GFX10: encoding: [0x7e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0
// GFX10: encoding: [0x80,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -1
// GFX10: encoding: [0xc1,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0.5
// GFX10: encoding: [0xf0,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -4.0
// GFX10: encoding: [0xf7,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0xaf123456
// GFX10: encoding: [0xff,0x2a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f64 v5, 0x3f717273
// GFX10: encoding: [0xff,0x2a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x02,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x04,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x64,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x80,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x01,0x01,0x00,0x20]

v_cvt_u32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[4:5] mul:2
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x04,0x00,0x00,0x08]

v_cvt_u32_f64_e64 v5, v[1:2] clamp div:2
// GFX10: encoding: [0x05,0x80,0x95,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f64_u32 v[5:6], v1
// GFX10: encoding: [0x01,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[254:255], v1
// GFX10: encoding: [0x01,0x2d,0xfc,0x7f]

v_cvt_f64_u32 v[5:6], v255
// GFX10: encoding: [0xff,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s1
// GFX10: encoding: [0x01,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s103
// GFX10: encoding: [0x67,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_lo
// GFX10: encoding: [0x6a,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_hi
// GFX10: encoding: [0x6b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], ttmp11
// GFX10: encoding: [0x77,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], m0
// GFX10: encoding: [0x7c,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_lo
// GFX10: encoding: [0x7e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_hi
// GFX10: encoding: [0x7f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0
// GFX10: encoding: [0x80,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -1
// GFX10: encoding: [0xc1,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x2c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_u32 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x2c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_u32_e64 v[5:6], v1
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[254:255], v1
// GFX10: encoding: [0xfe,0x00,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v255
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s101
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_lo
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_hi
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], m0
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_lo
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_hi
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 clamp
// GFX10: encoding: [0x05,0x80,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 mul:2
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], v1 mul:4
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f64_u32_e64 v[5:6], v1 div:2
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x18]

v_trunc_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x2f,0x0a,0x7e]

v_trunc_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x2f,0xfc,0x7f]

v_trunc_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x2f,0x0a,0x7e]

v_trunc_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x2e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x2e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xfe,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x02,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x04,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x64,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x80,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xf0,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xf7,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x20]

v_trunc_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x08]

v_trunc_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x10]

v_trunc_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x18]

v_ceil_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x31,0x0a,0x7e]

v_ceil_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x31,0xfc,0x7f]

v_ceil_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x31,0x0a,0x7e]

v_ceil_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x30,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x30,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xfe,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x02,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x04,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x64,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x80,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xf0,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xf7,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x20]

v_ceil_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x08]

v_ceil_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x10]

v_ceil_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x18]

v_rndne_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x33,0x0a,0x7e]

v_rndne_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x33,0xfc,0x7f]

v_rndne_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x33,0x0a,0x7e]

v_rndne_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x32,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x32,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xfe,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x02,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x04,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x64,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x80,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xf0,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xf7,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x20]

v_rndne_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x08]

v_rndne_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x10]

v_rndne_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x18]

v_floor_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x35,0x0a,0x7e]

v_floor_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x35,0xfc,0x7f]

v_floor_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x35,0x0a,0x7e]

v_floor_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x34,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x34,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xfe,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x02,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x04,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x64,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x80,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xf0,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xf7,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x20]

v_floor_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x08]

v_floor_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x10]

v_floor_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x18]

v_pipeflush
// GFX10: encoding: [0x00,0x36,0x00,0x7e]

v_pipeflush_e64
// GFX10: encoding: [0x00,0x00,0x9b,0xd5,0x00,0x00,0x00,0x00]

v_fract_f32 v5, v1
// GFX10: encoding: [0x01,0x41,0x0a,0x7e]

v_fract_f32 v255, v1
// GFX10: encoding: [0x01,0x41,0xfe,0x7f]

v_fract_f32 v5, v255
// GFX10: encoding: [0xff,0x41,0x0a,0x7e]

v_fract_f32 v5, s1
// GFX10: encoding: [0x01,0x40,0x0a,0x7e]

v_fract_f32 v5, s103
// GFX10: encoding: [0x67,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x40,0x0a,0x7e]

v_fract_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x40,0x0a,0x7e]

v_fract_f32 v5, m0
// GFX10: encoding: [0x7c,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x40,0x0a,0x7e]

v_fract_f32 v5, 0
// GFX10: encoding: [0x80,0x40,0x0a,0x7e]

v_fract_f32 v5, -1
// GFX10: encoding: [0xc1,0x40,0x0a,0x7e]

v_fract_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x40,0x0a,0x7e]

v_fract_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x40,0x0a,0x7e]

v_fract_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x40,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x40,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xff,0x01,0x00,0x00]

v_fract_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x00,0x00,0x00]

v_fract_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x65,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x6b,0x00,0x00,0x00]

v_fract_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x7f,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x80,0x00,0x00,0x00]

v_fract_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xf0,0x00,0x00,0x00]

v_fract_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xf7,0x00,0x00,0x00]

v_fract_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x20]

v_fract_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x08]

v_fract_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x10]

v_fract_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x18]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_fract_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_fract_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_fract_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_fract_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_fract_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_fract_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_fract_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_fract_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_fract_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_fract_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_fract_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_fract_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_fract_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_fract_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_fract_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_fract_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_fract_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_fract_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_fract_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_fract_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_fract_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_trunc_f32 v5, v1
// GFX10: encoding: [0x01,0x43,0x0a,0x7e]

v_trunc_f32 v255, v1
// GFX10: encoding: [0x01,0x43,0xfe,0x7f]

v_trunc_f32 v5, v255
// GFX10: encoding: [0xff,0x43,0x0a,0x7e]

v_trunc_f32 v5, s1
// GFX10: encoding: [0x01,0x42,0x0a,0x7e]

v_trunc_f32 v5, s103
// GFX10: encoding: [0x67,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x42,0x0a,0x7e]

v_trunc_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x42,0x0a,0x7e]

v_trunc_f32 v5, m0
// GFX10: encoding: [0x7c,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0
// GFX10: encoding: [0x80,0x42,0x0a,0x7e]

v_trunc_f32 v5, -1
// GFX10: encoding: [0xc1,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x42,0x0a,0x7e]

v_trunc_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x42,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x42,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xff,0x01,0x00,0x00]

v_trunc_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x00,0x00,0x00]

v_trunc_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x65,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x6b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x7f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x80,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xf0,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xf7,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x20]

v_trunc_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x08]

v_trunc_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x10]

v_trunc_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x18]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_trunc_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_trunc_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_trunc_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_trunc_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_trunc_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_trunc_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_trunc_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_trunc_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_trunc_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ceil_f32 v5, v1
// GFX10: encoding: [0x01,0x45,0x0a,0x7e]

v_ceil_f32 v255, v1
// GFX10: encoding: [0x01,0x45,0xfe,0x7f]

v_ceil_f32 v5, v255
// GFX10: encoding: [0xff,0x45,0x0a,0x7e]

v_ceil_f32 v5, s1
// GFX10: encoding: [0x01,0x44,0x0a,0x7e]

v_ceil_f32 v5, s103
// GFX10: encoding: [0x67,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x44,0x0a,0x7e]

v_ceil_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x44,0x0a,0x7e]

v_ceil_f32 v5, m0
// GFX10: encoding: [0x7c,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0
// GFX10: encoding: [0x80,0x44,0x0a,0x7e]

v_ceil_f32 v5, -1
// GFX10: encoding: [0xc1,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x44,0x0a,0x7e]

v_ceil_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x44,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x44,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xff,0x01,0x00,0x00]

v_ceil_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x00,0x00,0x00]

v_ceil_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x65,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x6b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x7f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x80,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xf0,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xf7,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x20]

v_ceil_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x08]

v_ceil_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x10]

v_ceil_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x18]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ceil_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_ceil_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_ceil_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ceil_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_ceil_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ceil_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ceil_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ceil_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ceil_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rndne_f32 v5, v1
// GFX10: encoding: [0x01,0x47,0x0a,0x7e]

v_rndne_f32 v255, v1
// GFX10: encoding: [0x01,0x47,0xfe,0x7f]

v_rndne_f32 v5, v255
// GFX10: encoding: [0xff,0x47,0x0a,0x7e]

v_rndne_f32 v5, s1
// GFX10: encoding: [0x01,0x46,0x0a,0x7e]

v_rndne_f32 v5, s103
// GFX10: encoding: [0x67,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x46,0x0a,0x7e]

v_rndne_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x46,0x0a,0x7e]

v_rndne_f32 v5, m0
// GFX10: encoding: [0x7c,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0
// GFX10: encoding: [0x80,0x46,0x0a,0x7e]

v_rndne_f32 v5, -1
// GFX10: encoding: [0xc1,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x46,0x0a,0x7e]

v_rndne_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x46,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x46,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xff,0x01,0x00,0x00]

v_rndne_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x00,0x00,0x00]

v_rndne_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x65,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x6b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x7f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x80,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xf0,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xf7,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x20]

v_rndne_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x08]

v_rndne_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x10]

v_rndne_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x18]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rndne_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rndne_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rndne_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rndne_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rndne_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rndne_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rndne_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rndne_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rndne_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_floor_f32 v5, v1
// GFX10: encoding: [0x01,0x49,0x0a,0x7e]

v_floor_f32 v255, v1
// GFX10: encoding: [0x01,0x49,0xfe,0x7f]

v_floor_f32 v5, v255
// GFX10: encoding: [0xff,0x49,0x0a,0x7e]

v_floor_f32 v5, s1
// GFX10: encoding: [0x01,0x48,0x0a,0x7e]

v_floor_f32 v5, s103
// GFX10: encoding: [0x67,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x48,0x0a,0x7e]

v_floor_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x48,0x0a,0x7e]

v_floor_f32 v5, m0
// GFX10: encoding: [0x7c,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x48,0x0a,0x7e]

v_floor_f32 v5, 0
// GFX10: encoding: [0x80,0x48,0x0a,0x7e]

v_floor_f32 v5, -1
// GFX10: encoding: [0xc1,0x48,0x0a,0x7e]

v_floor_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x48,0x0a,0x7e]

v_floor_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x48,0x0a,0x7e]

v_floor_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x48,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x48,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xff,0x01,0x00,0x00]

v_floor_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x00,0x00,0x00]

v_floor_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x65,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x6b,0x00,0x00,0x00]

v_floor_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x7f,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x80,0x00,0x00,0x00]

v_floor_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xf0,0x00,0x00,0x00]

v_floor_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xf7,0x00,0x00,0x00]

v_floor_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x20]

v_floor_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x08]

v_floor_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x10]

v_floor_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x18]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_floor_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_floor_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_floor_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_floor_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_floor_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_floor_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_floor_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_floor_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_floor_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_floor_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_floor_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_floor_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_floor_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_floor_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_floor_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_floor_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_floor_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_floor_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_floor_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_floor_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_floor_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_exp_f32 v5, v1
// GFX10: encoding: [0x01,0x4b,0x0a,0x7e]

v_exp_f32 v255, v1
// GFX10: encoding: [0x01,0x4b,0xfe,0x7f]

v_exp_f32 v5, v255
// GFX10: encoding: [0xff,0x4b,0x0a,0x7e]

v_exp_f32 v5, s1
// GFX10: encoding: [0x01,0x4a,0x0a,0x7e]

v_exp_f32 v5, s103
// GFX10: encoding: [0x67,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x4a,0x0a,0x7e]

v_exp_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x4a,0x0a,0x7e]

v_exp_f32 v5, m0
// GFX10: encoding: [0x7c,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0
// GFX10: encoding: [0x80,0x4a,0x0a,0x7e]

v_exp_f32 v5, -1
// GFX10: encoding: [0xc1,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x4a,0x0a,0x7e]

v_exp_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x4a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x4a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_exp_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xff,0x01,0x00,0x00]

v_exp_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x00,0x00,0x00]

v_exp_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x65,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x6a,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x6b,0x00,0x00,0x00]

v_exp_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x7c,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x7e,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x7f,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x80,0x00,0x00,0x00]

v_exp_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xc1,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xf0,0x00,0x00,0x00]

v_exp_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xf7,0x00,0x00,0x00]

v_exp_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x20]

v_exp_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x08]

v_exp_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x10]

v_exp_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x18]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_exp_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_exp_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_exp_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_exp_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_exp_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_exp_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_exp_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_exp_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_exp_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_exp_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_exp_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_exp_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_exp_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_exp_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_exp_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_exp_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_exp_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_exp_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_exp_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_exp_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_exp_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_log_f32 v5, v1
// GFX10: encoding: [0x01,0x4f,0x0a,0x7e]

v_log_f32 v255, v1
// GFX10: encoding: [0x01,0x4f,0xfe,0x7f]

v_log_f32 v5, v255
// GFX10: encoding: [0xff,0x4f,0x0a,0x7e]

v_log_f32 v5, s1
// GFX10: encoding: [0x01,0x4e,0x0a,0x7e]

v_log_f32 v5, s103
// GFX10: encoding: [0x67,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x4e,0x0a,0x7e]

v_log_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x4e,0x0a,0x7e]

v_log_f32 v5, m0
// GFX10: encoding: [0x7c,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x4e,0x0a,0x7e]

v_log_f32 v5, 0
// GFX10: encoding: [0x80,0x4e,0x0a,0x7e]

v_log_f32 v5, -1
// GFX10: encoding: [0xc1,0x4e,0x0a,0x7e]

v_log_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x4e,0x0a,0x7e]

v_log_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x4e,0x0a,0x7e]

v_log_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x4e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x4e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xff,0x01,0x00,0x00]

v_log_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x00,0x00,0x00]

v_log_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x65,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x6a,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x6b,0x00,0x00,0x00]

v_log_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x7c,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x7e,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x7f,0x00,0x00,0x00]

v_log_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x80,0x00,0x00,0x00]

v_log_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xc1,0x00,0x00,0x00]

v_log_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xf0,0x00,0x00,0x00]

v_log_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xf7,0x00,0x00,0x00]

v_log_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x20]

v_log_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x08]

v_log_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x10]

v_log_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x18]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_log_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_log_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_log_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_log_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_log_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_log_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_log_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_log_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_log_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_log_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_log_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_log_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_log_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_log_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_log_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_log_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_log_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_log_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_log_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_log_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_log_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_log_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_log_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_log_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_log_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_log_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_log_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_log_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_f32 v5, v1
// GFX10: encoding: [0x01,0x55,0x0a,0x7e]

v_rcp_f32 v255, v1
// GFX10: encoding: [0x01,0x55,0xfe,0x7f]

v_rcp_f32 v5, v255
// GFX10: encoding: [0xff,0x55,0x0a,0x7e]

v_rcp_f32 v5, s1
// GFX10: encoding: [0x01,0x54,0x0a,0x7e]

v_rcp_f32 v5, s103
// GFX10: encoding: [0x67,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x54,0x0a,0x7e]

v_rcp_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x54,0x0a,0x7e]

v_rcp_f32 v5, m0
// GFX10: encoding: [0x7c,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0
// GFX10: encoding: [0x80,0x54,0x0a,0x7e]

v_rcp_f32 v5, -1
// GFX10: encoding: [0xc1,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x54,0x0a,0x7e]

v_rcp_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x54,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x54,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xff,0x01,0x00,0x00]

v_rcp_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x00,0x00,0x00]

v_rcp_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x65,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x80,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x20]

v_rcp_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x08]

v_rcp_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x10]

v_rcp_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x18]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rcp_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rcp_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_iflag_f32 v5, v1
// GFX10: encoding: [0x01,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v255, v1
// GFX10: encoding: [0x01,0x57,0xfe,0x7f]

v_rcp_iflag_f32 v5, v255
// GFX10: encoding: [0xff,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v5, s1
// GFX10: encoding: [0x01,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, s103
// GFX10: encoding: [0x67,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, m0
// GFX10: encoding: [0x7c,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0
// GFX10: encoding: [0x80,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -1
// GFX10: encoding: [0xc1,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x56,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_iflag_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x56,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_iflag_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xff,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x65,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x80,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x20]

v_rcp_iflag_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x08]

v_rcp_iflag_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x10]

v_rcp_iflag_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x18]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_iflag_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_iflag_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rsq_f32 v5, v1
// GFX10: encoding: [0x01,0x5d,0x0a,0x7e]

v_rsq_f32 v255, v1
// GFX10: encoding: [0x01,0x5d,0xfe,0x7f]

v_rsq_f32 v5, v255
// GFX10: encoding: [0xff,0x5d,0x0a,0x7e]

v_rsq_f32 v5, s1
// GFX10: encoding: [0x01,0x5c,0x0a,0x7e]

v_rsq_f32 v5, s103
// GFX10: encoding: [0x67,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x5c,0x0a,0x7e]

v_rsq_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x5c,0x0a,0x7e]

v_rsq_f32 v5, m0
// GFX10: encoding: [0x7c,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0
// GFX10: encoding: [0x80,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -1
// GFX10: encoding: [0xc1,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x5c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x5c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xff,0x01,0x00,0x00]

v_rsq_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x00,0x00,0x00]

v_rsq_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x65,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x6b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x7f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x80,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xf0,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xf7,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x20]

v_rsq_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x08]

v_rsq_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x10]

v_rsq_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x18]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rsq_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rsq_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rsq_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rsq_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rsq_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rsq_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rsq_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rsq_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rsq_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x5f,0x0a,0x7e]

v_rcp_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x5f,0xfc,0x7f]

v_rcp_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x5f,0x0a,0x7e]

v_rcp_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x5e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x5e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xfe,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x02,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x04,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x64,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x80,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x20]

v_rcp_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x08]

v_rcp_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x10]

v_rcp_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x18]

v_rsq_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x63,0x0a,0x7e]

v_rsq_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x63,0xfc,0x7f]

v_rsq_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x63,0x0a,0x7e]

v_rsq_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x62,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x62,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xfe,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x02,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x04,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x64,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x80,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xf0,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xf7,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x20]

v_rsq_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x08]

v_rsq_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x10]

v_rsq_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x18]

v_sqrt_f32 v5, v1
// GFX10: encoding: [0x01,0x67,0x0a,0x7e]

v_sqrt_f32 v255, v1
// GFX10: encoding: [0x01,0x67,0xfe,0x7f]

v_sqrt_f32 v5, v255
// GFX10: encoding: [0xff,0x67,0x0a,0x7e]

v_sqrt_f32 v5, s1
// GFX10: encoding: [0x01,0x66,0x0a,0x7e]

v_sqrt_f32 v5, s103
// GFX10: encoding: [0x67,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x66,0x0a,0x7e]

v_sqrt_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x66,0x0a,0x7e]

v_sqrt_f32 v5, m0
// GFX10: encoding: [0x7c,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0
// GFX10: encoding: [0x80,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -1
// GFX10: encoding: [0xc1,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x66,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x66,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xff,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x65,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x6b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x7f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x80,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xf0,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xf7,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x20]

v_sqrt_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x08]

v_sqrt_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x10]

v_sqrt_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x18]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sqrt_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sqrt_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sqrt_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sqrt_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sqrt_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sqrt_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_sqrt_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x69,0x0a,0x7e]

v_sqrt_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x69,0xfc,0x7f]

v_sqrt_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x69,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x68,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x68,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xfe,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x02,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x04,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x64,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x80,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xf0,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xf7,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x20]

v_sqrt_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x08]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x10]

v_sqrt_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x18]

v_sin_f32 v5, v1
// GFX10: encoding: [0x01,0x6b,0x0a,0x7e]

v_sin_f32 v255, v1
// GFX10: encoding: [0x01,0x6b,0xfe,0x7f]

v_sin_f32 v5, v255
// GFX10: encoding: [0xff,0x6b,0x0a,0x7e]

v_sin_f32 v5, s1
// GFX10: encoding: [0x01,0x6a,0x0a,0x7e]

v_sin_f32 v5, s103
// GFX10: encoding: [0x67,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x6a,0x0a,0x7e]

v_sin_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x6a,0x0a,0x7e]

v_sin_f32 v5, m0
// GFX10: encoding: [0x7c,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0
// GFX10: encoding: [0x80,0x6a,0x0a,0x7e]

v_sin_f32 v5, -1
// GFX10: encoding: [0xc1,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x6a,0x0a,0x7e]

v_sin_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x6a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sin_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x6a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sin_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xff,0x01,0x00,0x00]

v_sin_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x00,0x00,0x00]

v_sin_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x65,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x6a,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x6b,0x00,0x00,0x00]

v_sin_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x7c,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x7e,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x7f,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x80,0x00,0x00,0x00]

v_sin_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xc1,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xf0,0x00,0x00,0x00]

v_sin_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xf7,0x00,0x00,0x00]

v_sin_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x20]

v_sin_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x08]

v_sin_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x10]

v_sin_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x18]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sin_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_sin_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_sin_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_sin_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_sin_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_sin_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_sin_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_sin_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sin_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_sin_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_sin_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sin_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sin_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sin_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sin_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sin_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sin_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sin_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sin_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_sin_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_sin_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cos_f32 v5, v1
// GFX10: encoding: [0x01,0x6d,0x0a,0x7e]

v_cos_f32 v255, v1
// GFX10: encoding: [0x01,0x6d,0xfe,0x7f]

v_cos_f32 v5, v255
// GFX10: encoding: [0xff,0x6d,0x0a,0x7e]

v_cos_f32 v5, s1
// GFX10: encoding: [0x01,0x6c,0x0a,0x7e]

v_cos_f32 v5, s103
// GFX10: encoding: [0x67,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x6c,0x0a,0x7e]

v_cos_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x6c,0x0a,0x7e]

v_cos_f32 v5, m0
// GFX10: encoding: [0x7c,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0
// GFX10: encoding: [0x80,0x6c,0x0a,0x7e]

v_cos_f32 v5, -1
// GFX10: encoding: [0xc1,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x6c,0x0a,0x7e]

v_cos_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x6c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cos_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x6c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cos_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xff,0x01,0x00,0x00]

v_cos_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x00,0x00,0x00]

v_cos_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x65,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x6a,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x6b,0x00,0x00,0x00]

v_cos_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x7c,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x7e,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x7f,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x80,0x00,0x00,0x00]

v_cos_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xc1,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xf0,0x00,0x00,0x00]

v_cos_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xf7,0x00,0x00,0x00]

v_cos_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x20]

v_cos_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x08]

v_cos_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x10]

v_cos_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x18]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cos_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cos_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cos_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cos_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cos_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cos_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cos_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cos_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cos_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cos_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cos_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cos_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cos_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cos_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cos_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cos_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cos_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cos_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cos_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cos_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cos_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_not_b32 v5, v1
// GFX10: encoding: [0x01,0x6f,0x0a,0x7e]

v_not_b32 v255, v1
// GFX10: encoding: [0x01,0x6f,0xfe,0x7f]

v_not_b32 v5, v255
// GFX10: encoding: [0xff,0x6f,0x0a,0x7e]

v_not_b32 v5, s1
// GFX10: encoding: [0x01,0x6e,0x0a,0x7e]

v_not_b32 v5, s103
// GFX10: encoding: [0x67,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x6e,0x0a,0x7e]

v_not_b32 v5, ttmp11
// GFX10: encoding: [0x77,0x6e,0x0a,0x7e]

v_not_b32 v5, m0
// GFX10: encoding: [0x7c,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_lo
// GFX10: encoding: [0x7e,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_hi
// GFX10: encoding: [0x7f,0x6e,0x0a,0x7e]

v_not_b32 v5, 0
// GFX10: encoding: [0x80,0x6e,0x0a,0x7e]

v_not_b32 v5, -1
// GFX10: encoding: [0xc1,0x6e,0x0a,0x7e]

v_not_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x6e,0x0a,0x7e]

v_not_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x6e,0x0a,0x7e]

v_not_b32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x6e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_not_b32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x6e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_not_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x01,0x01,0x00,0x00]

v_not_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb7,0xd5,0x01,0x01,0x00,0x00]

v_not_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xff,0x01,0x00,0x00]

v_not_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x01,0x00,0x00,0x00]

v_not_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x65,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x6a,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x6b,0x00,0x00,0x00]

v_not_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x7c,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x7e,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x7f,0x00,0x00,0x00]

v_not_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x80,0x00,0x00,0x00]

v_not_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xc1,0x00,0x00,0x00]

v_not_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xf0,0x00,0x00,0x00]

v_not_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xf7,0x00,0x00,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_not_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_not_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_not_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_not_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_not_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_not_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_not_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_not_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_not_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_not_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_not_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_not_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_not_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_not_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_not_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_not_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_not_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_not_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_not_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_not_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_not_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_not_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_not_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_not_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_bfrev_b32 v5, v1
// GFX10: encoding: [0x01,0x71,0x0a,0x7e]

v_bfrev_b32 v255, v1
// GFX10: encoding: [0x01,0x71,0xfe,0x7f]

v_bfrev_b32 v5, v255
// GFX10: encoding: [0xff,0x71,0x0a,0x7e]

v_bfrev_b32 v5, s1
// GFX10: encoding: [0x01,0x70,0x0a,0x7e]

v_bfrev_b32 v5, s103
// GFX10: encoding: [0x67,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x70,0x0a,0x7e]

v_bfrev_b32 v5, ttmp11
// GFX10: encoding: [0x77,0x70,0x0a,0x7e]

v_bfrev_b32 v5, m0
// GFX10: encoding: [0x7c,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_lo
// GFX10: encoding: [0x7e,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_hi
// GFX10: encoding: [0x7f,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0
// GFX10: encoding: [0x80,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -1
// GFX10: encoding: [0xc1,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x70,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_bfrev_b32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x70,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_bfrev_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb8,0xd5,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xff,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x01,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x65,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x6a,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x6b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x7c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x7e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x7f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x80,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xc1,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xf0,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xf7,0x00,0x00,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_bfrev_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_bfrev_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_bfrev_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_bfrev_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_bfrev_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ffbh_u32 v5, v1
// GFX10: encoding: [0x01,0x73,0x0a,0x7e]

v_ffbh_u32 v255, v1
// GFX10: encoding: [0x01,0x73,0xfe,0x7f]

v_ffbh_u32 v5, v255
// GFX10: encoding: [0xff,0x73,0x0a,0x7e]

v_ffbh_u32 v5, s1
// GFX10: encoding: [0x01,0x72,0x0a,0x7e]

v_ffbh_u32 v5, s103
// GFX10: encoding: [0x67,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x72,0x0a,0x7e]

v_ffbh_u32 v5, ttmp11
// GFX10: encoding: [0x77,0x72,0x0a,0x7e]

v_ffbh_u32 v5, m0
// GFX10: encoding: [0x7c,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_lo
// GFX10: encoding: [0x7e,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_hi
// GFX10: encoding: [0x7f,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0
// GFX10: encoding: [0x80,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -1
// GFX10: encoding: [0xc1,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0.5
// GFX10: encoding: [0xf0,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -4.0
// GFX10: encoding: [0xf7,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x72,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_u32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x72,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_u32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb9,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xff,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x01,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x65,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x6a,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x6b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x7c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x7e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x7f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x80,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xc1,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xf0,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xf7,0x00,0x00,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbh_u32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbh_u32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbh_u32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbh_u32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbh_u32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ffbl_b32 v5, v1
// GFX10: encoding: [0x01,0x75,0x0a,0x7e]

v_ffbl_b32 v255, v1
// GFX10: encoding: [0x01,0x75,0xfe,0x7f]

v_ffbl_b32 v5, v255
// GFX10: encoding: [0xff,0x75,0x0a,0x7e]

v_ffbl_b32 v5, s1
// GFX10: encoding: [0x01,0x74,0x0a,0x7e]

v_ffbl_b32 v5, s103
// GFX10: encoding: [0x67,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x74,0x0a,0x7e]

v_ffbl_b32 v5, ttmp11
// GFX10: encoding: [0x77,0x74,0x0a,0x7e]

v_ffbl_b32 v5, m0
// GFX10: encoding: [0x7c,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_lo
// GFX10: encoding: [0x7e,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_hi
// GFX10: encoding: [0x7f,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0
// GFX10: encoding: [0x80,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -1
// GFX10: encoding: [0xc1,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x74,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbl_b32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x74,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbl_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xba,0xd5,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xff,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x01,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x65,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x6a,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x6b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x7c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x7e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x7f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x80,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xc1,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xf0,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xf7,0x00,0x00,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbl_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbl_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbl_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbl_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbl_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ffbh_i32 v5, v1
// GFX10: encoding: [0x01,0x77,0x0a,0x7e]

v_ffbh_i32 v255, v1
// GFX10: encoding: [0x01,0x77,0xfe,0x7f]

v_ffbh_i32 v5, v255
// GFX10: encoding: [0xff,0x77,0x0a,0x7e]

v_ffbh_i32 v5, s1
// GFX10: encoding: [0x01,0x76,0x0a,0x7e]

v_ffbh_i32 v5, s103
// GFX10: encoding: [0x67,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x76,0x0a,0x7e]

v_ffbh_i32 v5, ttmp11
// GFX10: encoding: [0x77,0x76,0x0a,0x7e]

v_ffbh_i32 v5, m0
// GFX10: encoding: [0x7c,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_lo
// GFX10: encoding: [0x7e,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_hi
// GFX10: encoding: [0x7f,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0
// GFX10: encoding: [0x80,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -1
// GFX10: encoding: [0xc1,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0.5
// GFX10: encoding: [0xf0,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -4.0
// GFX10: encoding: [0xf7,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x76,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_i32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x76,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_i32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xbb,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xff,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x01,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x65,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x6a,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x6b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x7c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x7e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x7f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x80,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xc1,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xf0,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xf7,0x00,0x00,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbh_i32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbh_i32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbh_i32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbh_i32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbh_i32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbh_i32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_frexp_exp_i32_f64 v5, v[1:2]
// GFX10: encoding: [0x01,0x79,0x0a,0x7e]

v_frexp_exp_i32_f64 v255, v[1:2]
// GFX10: encoding: [0x01,0x79,0xfe,0x7f]

v_frexp_exp_i32_f64 v5, v[254:255]
// GFX10: encoding: [0xfe,0x79,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[2:3]
// GFX10: encoding: [0x02,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[4:5]
// GFX10: encoding: [0x04,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[102:103]
// GFX10: encoding: [0x66,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, vcc
// GFX10: encoding: [0x6a,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, exec
// GFX10: encoding: [0x7e,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0
// GFX10: encoding: [0x80,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -1
// GFX10: encoding: [0xc1,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0.5
// GFX10: encoding: [0xf0,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -4.0
// GFX10: encoding: [0xf7,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0xaf123456
// GFX10: encoding: [0xff,0x78,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f64 v5, 0x3f717273
// GFX10: encoding: [0xff,0x78,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0xbc,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0xfe,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x02,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x04,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x64,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0xbc,0xd5,0x01,0x01,0x00,0x20]

v_frexp_exp_i32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xbc,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xbc,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x7b,0x0a,0x7e]

v_frexp_mant_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x7b,0xfc,0x7f]

v_frexp_mant_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x7b,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x7a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x7a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xbd,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0xfe,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x02,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x04,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x64,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x80,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0xf7,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x01,0x01,0x00,0x20]

v_frexp_mant_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xbd,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xbd,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x01,0x01,0x00,0x08]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x01,0x01,0x00,0x10]

v_frexp_mant_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xbd,0xd5,0x01,0x01,0x00,0x18]

v_fract_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x7d,0x0a,0x7e]

v_fract_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x7d,0xfc,0x7f]

v_fract_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x7d,0x0a,0x7e]

v_fract_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x7c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x7c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xbe,0xd5,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0xfe,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x02,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x04,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x64,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x80,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0xf0,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0xf7,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x01,0x01,0x00,0x20]

v_fract_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xbe,0xd5,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xbe,0xd5,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x01,0x01,0x00,0x08]

v_fract_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x01,0x01,0x00,0x10]

v_fract_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xbe,0xd5,0x01,0x01,0x00,0x18]

v_frexp_exp_i32_f32 v5, v1
// GFX10: encoding: [0x01,0x7f,0x0a,0x7e]

v_frexp_exp_i32_f32 v255, v1
// GFX10: encoding: [0x01,0x7f,0xfe,0x7f]

v_frexp_exp_i32_f32 v5, v255
// GFX10: encoding: [0xff,0x7f,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s1
// GFX10: encoding: [0x01,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s103
// GFX10: encoding: [0x67,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, m0
// GFX10: encoding: [0x7c,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0
// GFX10: encoding: [0x80,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -1
// GFX10: encoding: [0xc1,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x7e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x7e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xbf,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0xff,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x01,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x65,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xbf,0xd5,0x01,0x01,0x00,0x20]

v_frexp_exp_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xbf,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xbf,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_exp_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_exp_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_exp_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_exp_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_frexp_mant_f32 v5, v1
// GFX10: encoding: [0x01,0x81,0x0a,0x7e]

v_frexp_mant_f32 v255, v1
// GFX10: encoding: [0x01,0x81,0xfe,0x7f]

v_frexp_mant_f32 v5, v255
// GFX10: encoding: [0xff,0x81,0x0a,0x7e]

v_frexp_mant_f32 v5, s1
// GFX10: encoding: [0x01,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, s103
// GFX10: encoding: [0x67,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, m0
// GFX10: encoding: [0x7c,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0
// GFX10: encoding: [0x80,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, -1
// GFX10: encoding: [0xc1,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x80,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x80,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xc0,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0xff,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x01,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x65,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x80,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0xf7,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x01,0x01,0x00,0x20]

v_frexp_mant_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xc0,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xc0,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x01,0x01,0x00,0x08]

v_frexp_mant_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x01,0x01,0x00,0x10]

v_frexp_mant_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xc0,0xd5,0x01,0x01,0x00,0x18]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_frexp_mant_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_mant_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_mant_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_mant_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_mant_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_mant_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_mant_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_clrexcp_e32
// GFX10: encoding: [0x00,0x82,0x00,0x7e]

v_clrexcp_e64
// GFX10: encoding: [0x00,0x00,0xc1,0xd5,0x00,0x00,0x00,0x00]

v_movreld_b32 v5, v1
// GFX10: encoding: [0x01,0x85,0x0a,0x7e]

v_movreld_b32 v255, v1
// GFX10: encoding: [0x01,0x85,0xfe,0x7f]

v_movreld_b32 v5, v255
// GFX10: encoding: [0xff,0x85,0x0a,0x7e]

v_movreld_b32 v5, m0
// GFX10: encoding: [0x7c,0x84,0x0a,0x7e]

v_movreld_b32 v5, 0
// GFX10: encoding: [0x80,0x84,0x0a,0x7e]

v_movreld_b32 v5, -1
// GFX10: encoding: [0xc1,0x84,0x0a,0x7e]

v_movreld_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x84,0x0a,0x7e]

v_movreld_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x84,0x0a,0x7e]

v_movreld_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xc2,0xd5,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0xff,0x01,0x00,0x00]

v_movreld_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0x7c,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0x80,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0xc1,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0xf0,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xc2,0xd5,0xf7,0x00,0x00,0x00]

v_movreld_b32_sdwa v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x84,0x00,0x7e,0x02,0x06,0x06,0x00]

v_movreld_b32_sdwa v0, s2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x84,0x00,0x7e,0x02,0x06,0x86,0x00]

v_movreld_b32_sdwa v0, 64 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x84,0x00,0x7e,0xc0,0x06,0x86,0x00]

v_movreld_b32_sdwa v0, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x84,0x00,0x7e,0x00,0x06,0x0e,0x00]

v_movrels_b32 v5, v1
// GFX10: encoding: [0x01,0x87,0x0a,0x7e]

v_movrels_b32 v255, v1
// GFX10: encoding: [0x01,0x87,0xfe,0x7f]

v_movrels_b32 v5, v255
// GFX10: encoding: [0xff,0x87,0x0a,0x7e]

v_movrels_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xc3,0xd5,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xc3,0xd5,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xc3,0xd5,0xff,0x01,0x00,0x00]

v_movrels_b32_sdwa v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x86,0x00,0x7e,0x02,0x06,0x06,0x00]

v_movrels_b32_sdwa v0, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x86,0x00,0x7e,0x00,0x06,0x0e,0x00]

v_movrels_b32_e32 v5, s1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrels_b32_e32 v5, 1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrels_b32_e64 v5, s1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrels_b32_e64 v5, 1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrels_b32_sdwa v0, s2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_movrels_b32_sdwa v0, 1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_movrelsd_b32 v5, v1
// GFX10: encoding: [0x01,0x89,0x0a,0x7e]

v_movrelsd_b32 v255, v1
// GFX10: encoding: [0x01,0x89,0xfe,0x7f]

v_movrelsd_b32 v5, v255
// GFX10: encoding: [0xff,0x89,0x0a,0x7e]

v_movrelsd_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xc4,0xd5,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xc4,0xd5,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xc4,0xd5,0xff,0x01,0x00,0x00]

v_movrelsd_b32_sdwa v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x88,0x00,0x7e,0x02,0x06,0x06,0x00]

v_movrelsd_b32_sdwa v0, v0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x88,0x00,0x7e,0x00,0x06,0x06,0x00]

v_movrelsd_b32_sdwa v0, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x88,0x00,0x7e,0x00,0x06,0x0e,0x00]

v_movrelsd_b32_e32 v5, s1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_b32_e32 v5, 1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_b32_e64 v5, s1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_b32_e64 v5, 1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_b32_sdwa v0, s2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_movrelsd_b32_sdwa v0, 1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_movrelsd_2_b32 v5, v1
// GFX10: encoding: [0x01,0x91,0x0a,0x7e]

v_movrelsd_2_b32 v255, v1
// GFX10: encoding: [0x01,0x91,0xfe,0x7f]

v_movrelsd_2_b32 v5, v255
// GFX10: encoding: [0xff,0x91,0x0a,0x7e]

v_movrelsd_2_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xc8,0xd5,0x01,0x01,0x00,0x00]

v_movrelsd_2_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xc8,0xd5,0x01,0x01,0x00,0x00]

v_movrelsd_2_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xc8,0xd5,0xff,0x01,0x00,0x00]

v_movrelsd_2_b32_sdwa v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x90,0x00,0x7e,0x02,0x06,0x06,0x00]

v_movrelsd_2_b32_sdwa v0, v0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x90,0x00,0x7e,0x00,0x06,0x06,0x00]

v_movrelsd_2_b32_sdwa v0, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x90,0x00,0x7e,0x00,0x06,0x0e,0x00]

v_movrelsd_2_b32_e32 v5, s1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_2_b32_e32 v5, 1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_2_b32_e64 v5, s1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_2_b32_e64 v5, 1
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_movrelsd_2_b32_sdwa v0, s2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_movrelsd_2_b32_sdwa v0, 0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_movrelsd_2_b32_sdwa v0, null dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: source operand must be a VGPR

v_cvt_f16_u16_e32 v5, v1
// GFX10: encoding: [0x01,0xa1,0x0a,0x7e]

v_cvt_f16_u16_e32 v255, v1
// GFX10: encoding: [0x01,0xa1,0xfe,0x7f]

v_cvt_f16_u16_e32 v5, v255
// GFX10: encoding: [0xff,0xa1,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, s1
// GFX10: encoding: [0x01,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, s101
// GFX10: encoding: [0x65,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, m0
// GFX10: encoding: [0x7c,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, 0
// GFX10: encoding: [0x80,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, -1
// GFX10: encoding: [0xc1,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xa0,0x0a,0x7e]

v_cvt_f16_u16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xa0,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_f16_u16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xa0,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_f16_u16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd0,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd0,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd0,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f16_u16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_u16_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa0,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_u16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_u16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_u16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f16_u16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f16_i16_e32 v5, v1
// GFX10: encoding: [0x01,0xa3,0x0a,0x7e]

v_cvt_f16_i16_e32 v255, v1
// GFX10: encoding: [0x01,0xa3,0xfe,0x7f]

v_cvt_f16_i16_e32 v5, v255
// GFX10: encoding: [0xff,0xa3,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, s1
// GFX10: encoding: [0x01,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, s101
// GFX10: encoding: [0x65,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, m0
// GFX10: encoding: [0x7c,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, 0
// GFX10: encoding: [0x80,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, -1
// GFX10: encoding: [0xc1,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xa2,0x0a,0x7e]

v_cvt_f16_i16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xa2,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_f16_i16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xa2,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_f16_i16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd1,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd1,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd1,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f16_i16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_i16_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa2,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_i16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_i16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_i16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f16_i16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_u16_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xa5,0x0a,0x7e]

v_cvt_u16_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xa5,0xfe,0x7f]

v_cvt_u16_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xa5,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xa4,0x0a,0x7e]

v_cvt_u16_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xa4,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_u16_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xa4,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_u16_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x65,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x80,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x01,0x01,0x00,0x20]

v_cvt_u16_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, s1 mul:2
// GFX10: encoding: [0x05,0x00,0xd2,0xd5,0x01,0x00,0x00,0x08]

v_cvt_u16_f16_e64 v5, v1 clamp div:2
// GFX10: encoding: [0x05,0x80,0xd2,0xd5,0x01,0x01,0x00,0x18]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_u16_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_u16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_u16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa4,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_u16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_u16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_u16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u16_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_i16_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xa7,0x0a,0x7e]

v_cvt_i16_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xa7,0xfe,0x7f]

v_cvt_i16_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xa7,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xa6,0x0a,0x7e]

v_cvt_i16_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xa6,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_i16_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xa6,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_i16_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x65,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x80,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x01,0x01,0x00,0x20]

v_cvt_i16_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xd3,0xd5,0x01,0x01,0x00,0x08]

v_cvt_i16_f16_e64 v5, v1 clamp div:2
// GFX10: encoding: [0x05,0x80,0xd3,0xd5,0x01,0x01,0x00,0x18]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_i16_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_i16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_i16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa6,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_i16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_i16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_i16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_i16_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xa9,0x0a,0x7e]

v_rcp_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xa9,0xfe,0x7f]

v_rcp_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xa9,0x0a,0x7e]

v_rcp_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xa8,0x0a,0x7e]

v_rcp_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xa8,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_rcp_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xa8,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_rcp_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd4,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0xff,0x01,0x00,0x00]

v_rcp_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x01,0x00,0x00,0x00]

v_rcp_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x65,0x00,0x00,0x00]

v_rcp_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x80,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd4,0xd5,0x01,0x01,0x00,0x20]

v_rcp_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd4,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd4,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rcp_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xa8,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_sqrt_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xab,0x0a,0x7e]

v_sqrt_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xab,0xfe,0x7f]

v_sqrt_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xab,0x0a,0x7e]

v_sqrt_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xaa,0x0a,0x7e]

v_sqrt_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xaa,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_sqrt_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xaa,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_sqrt_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd5,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0xff,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x01,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x65,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x6b,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x7f,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x80,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0xf0,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0xf7,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd5,0xd5,0x01,0x01,0x00,0x20]

v_sqrt_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd5,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd5,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sqrt_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sqrt_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_sqrt_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sqrt_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sqrt_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xaa,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sqrt_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sqrt_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sqrt_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sqrt_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sqrt_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rsq_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xad,0x0a,0x7e]

v_rsq_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xad,0xfe,0x7f]

v_rsq_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xad,0x0a,0x7e]

v_rsq_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xac,0x0a,0x7e]

v_rsq_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xac,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_rsq_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xac,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_rsq_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd6,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0xff,0x01,0x00,0x00]

v_rsq_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x01,0x00,0x00,0x00]

v_rsq_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x65,0x00,0x00,0x00]

v_rsq_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x6b,0x00,0x00,0x00]

v_rsq_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x7f,0x00,0x00,0x00]

v_rsq_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x80,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0xf0,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0xf7,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd6,0xd5,0x01,0x01,0x00,0x20]

v_rsq_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd6,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd6,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rsq_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rsq_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rsq_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rsq_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rsq_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xac,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rsq_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rsq_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rsq_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rsq_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rsq_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_log_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xaf,0x0a,0x7e]

v_log_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xaf,0xfe,0x7f]

v_log_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xaf,0x0a,0x7e]

v_log_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xae,0x0a,0x7e]

v_log_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xae,0x0a,0x7e]

v_log_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xae,0x0a,0x7e]

v_log_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xae,0x0a,0x7e]

v_log_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xae,0x0a,0x7e]

v_log_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xae,0x0a,0x7e]

v_log_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xae,0x0a,0x7e]

v_log_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xae,0x0a,0x7e]

v_log_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xae,0x0a,0x7e]

v_log_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xae,0x0a,0x7e]

v_log_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xae,0x0a,0x7e]

v_log_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xae,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_log_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xae,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_log_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x01,0x01,0x00,0x00]

v_log_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd7,0xd5,0x01,0x01,0x00,0x00]

v_log_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0xff,0x01,0x00,0x00]

v_log_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x01,0x00,0x00,0x00]

v_log_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x65,0x00,0x00,0x00]

v_log_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x6a,0x00,0x00,0x00]

v_log_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x6b,0x00,0x00,0x00]

v_log_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x7c,0x00,0x00,0x00]

v_log_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x7e,0x00,0x00,0x00]

v_log_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x7f,0x00,0x00,0x00]

v_log_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x80,0x00,0x00,0x00]

v_log_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0xc1,0x00,0x00,0x00]

v_log_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0xf0,0x00,0x00,0x00]

v_log_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0xf7,0x00,0x00,0x00]

v_log_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd7,0xd5,0x01,0x01,0x00,0x20]

v_log_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd7,0xd5,0x01,0x01,0x00,0x00]

v_log_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd7,0xd5,0x01,0x01,0x00,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_log_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_log_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_log_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_log_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_log_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_log_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_log_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_log_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_log_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_log_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_log_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xae,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_log_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_log_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_log_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_log_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_log_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_log_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_log_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_log_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_log_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_log_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_log_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_log_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_log_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_log_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_log_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_exp_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xb1,0x0a,0x7e]

v_exp_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xb1,0xfe,0x7f]

v_exp_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xb1,0x0a,0x7e]

v_exp_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xb0,0x0a,0x7e]

v_exp_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xb0,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_exp_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xb0,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_exp_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd8,0xd5,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0xff,0x01,0x00,0x00]

v_exp_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x01,0x00,0x00,0x00]

v_exp_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x65,0x00,0x00,0x00]

v_exp_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x6a,0x00,0x00,0x00]

v_exp_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x6b,0x00,0x00,0x00]

v_exp_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x7c,0x00,0x00,0x00]

v_exp_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x7e,0x00,0x00,0x00]

v_exp_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x7f,0x00,0x00,0x00]

v_exp_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x80,0x00,0x00,0x00]

v_exp_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0xc1,0x00,0x00,0x00]

v_exp_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0xf0,0x00,0x00,0x00]

v_exp_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0xf7,0x00,0x00,0x00]

v_exp_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd8,0xd5,0x01,0x01,0x00,0x20]

v_exp_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd8,0xd5,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd8,0xd5,0x01,0x01,0x00,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_exp_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_exp_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_exp_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_exp_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_exp_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_exp_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_exp_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_exp_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_exp_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_exp_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_exp_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb0,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_exp_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_exp_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_exp_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_exp_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_exp_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_exp_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_exp_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_exp_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_exp_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_exp_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_exp_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_frexp_mant_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xb3,0x0a,0x7e]

v_frexp_mant_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xb3,0xfe,0x7f]

v_frexp_mant_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xb3,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xb2,0x0a,0x7e]

v_frexp_mant_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xb2,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_frexp_mant_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xb2,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_frexp_mant_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0xff,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x01,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x65,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x80,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0xf7,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xd9,0xd5,0x01,0x01,0x00,0x20]

v_frexp_mant_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_frexp_mant_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_mant_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_mant_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb2,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_mant_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_mant_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_mant_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_mant_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_frexp_exp_i16_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xb5,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xb5,0xfe,0x7f]

v_frexp_exp_i16_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xb5,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xb4,0x0a,0x7e]

v_frexp_exp_i16_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xb4,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_frexp_exp_i16_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xb4,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0xff,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x01,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x65,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x80,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0xf7,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xda,0xd5,0x01,0x01,0x00,0x20]

v_frexp_exp_i16_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_exp_i16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_exp_i16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb4,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_exp_i16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_exp_i16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_floor_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xb7,0x0a,0x7e]

v_floor_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xb7,0xfe,0x7f]

v_floor_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xb7,0x0a,0x7e]

v_floor_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xb6,0x0a,0x7e]

v_floor_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xb6,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_floor_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xb6,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_floor_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xdb,0xd5,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0xff,0x01,0x00,0x00]

v_floor_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x01,0x00,0x00,0x00]

v_floor_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x65,0x00,0x00,0x00]

v_floor_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x6b,0x00,0x00,0x00]

v_floor_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x7f,0x00,0x00,0x00]

v_floor_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x80,0x00,0x00,0x00]

v_floor_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0xf0,0x00,0x00,0x00]

v_floor_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0xf7,0x00,0x00,0x00]

v_floor_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xdb,0xd5,0x01,0x01,0x00,0x20]

v_floor_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xdb,0xd5,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xdb,0xd5,0x01,0x01,0x00,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_floor_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_floor_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_floor_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_floor_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_floor_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_floor_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_floor_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_floor_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_floor_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_floor_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_floor_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb6,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_floor_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_floor_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_floor_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_floor_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_floor_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_floor_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_floor_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_floor_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_floor_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_floor_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_floor_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ceil_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xb9,0x0a,0x7e]

v_ceil_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xb9,0xfe,0x7f]

v_ceil_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xb9,0x0a,0x7e]

v_ceil_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xb8,0x0a,0x7e]

v_ceil_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xb8,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_ceil_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xb8,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_ceil_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xdc,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0xff,0x01,0x00,0x00]

v_ceil_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x01,0x00,0x00,0x00]

v_ceil_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x65,0x00,0x00,0x00]

v_ceil_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x6b,0x00,0x00,0x00]

v_ceil_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x7f,0x00,0x00,0x00]

v_ceil_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x80,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0xf0,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0xf7,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xdc,0xd5,0x01,0x01,0x00,0x20]

v_ceil_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xdc,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xdc,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ceil_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ceil_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ceil_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ceil_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_ceil_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xb8,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ceil_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ceil_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ceil_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ceil_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ceil_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_trunc_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xbb,0x0a,0x7e]

v_trunc_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xbb,0xfe,0x7f]

v_trunc_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xbb,0x0a,0x7e]

v_trunc_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xba,0x0a,0x7e]

v_trunc_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xba,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_trunc_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xba,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_trunc_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0xff,0x01,0x00,0x00]

v_trunc_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x01,0x00,0x00,0x00]

v_trunc_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x65,0x00,0x00,0x00]

v_trunc_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x6b,0x00,0x00,0x00]

v_trunc_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x7f,0x00,0x00,0x00]

v_trunc_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x80,0x00,0x00,0x00]

v_trunc_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0xf0,0x00,0x00,0x00]

v_trunc_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0xf7,0x00,0x00,0x00]

v_trunc_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xdd,0xd5,0x01,0x01,0x00,0x20]

v_trunc_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_trunc_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_trunc_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_trunc_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_trunc_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_trunc_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xba,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_trunc_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_trunc_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_trunc_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_trunc_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_trunc_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rndne_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xbd,0x0a,0x7e]

v_rndne_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xbd,0xfe,0x7f]

v_rndne_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xbd,0x0a,0x7e]

v_rndne_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xbc,0x0a,0x7e]

v_rndne_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xbc,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_rndne_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xbc,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_rndne_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0xff,0x01,0x00,0x00]

v_rndne_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x01,0x00,0x00,0x00]

v_rndne_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x65,0x00,0x00,0x00]

v_rndne_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x6b,0x00,0x00,0x00]

v_rndne_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x7f,0x00,0x00,0x00]

v_rndne_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x80,0x00,0x00,0x00]

v_rndne_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0xf0,0x00,0x00,0x00]

v_rndne_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0xf7,0x00,0x00,0x00]

v_rndne_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xde,0xd5,0x01,0x01,0x00,0x20]

v_rndne_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rndne_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rndne_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rndne_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rndne_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rndne_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbc,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rndne_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rndne_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rndne_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rndne_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rndne_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_fract_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xbf,0x0a,0x7e]

v_fract_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xbf,0xfe,0x7f]

v_fract_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xbf,0x0a,0x7e]

v_fract_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xbe,0x0a,0x7e]

v_fract_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xbe,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_fract_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xbe,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_fract_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0xff,0x01,0x00,0x00]

v_fract_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x01,0x00,0x00,0x00]

v_fract_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x65,0x00,0x00,0x00]

v_fract_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x6b,0x00,0x00,0x00]

v_fract_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x7f,0x00,0x00,0x00]

v_fract_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x80,0x00,0x00,0x00]

v_fract_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0xf0,0x00,0x00,0x00]

v_fract_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0xf7,0x00,0x00,0x00]

v_fract_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xdf,0xd5,0x01,0x01,0x00,0x20]

v_fract_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_fract_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_fract_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_fract_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_fract_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_fract_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_fract_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_fract_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_fract_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_fract_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_fract_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_fract_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xbe,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_fract_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_fract_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_fract_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_fract_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_fract_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_fract_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_fract_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_fract_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_fract_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_fract_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_fract_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_sin_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xc1,0x0a,0x7e]

v_sin_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xc1,0xfe,0x7f]

v_sin_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xc1,0x0a,0x7e]

v_sin_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xc0,0x0a,0x7e]

v_sin_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xc0,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_sin_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xc0,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_sin_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0xff,0x01,0x00,0x00]

v_sin_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x01,0x00,0x00,0x00]

v_sin_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x65,0x00,0x00,0x00]

v_sin_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x6a,0x00,0x00,0x00]

v_sin_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x6b,0x00,0x00,0x00]

v_sin_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x7c,0x00,0x00,0x00]

v_sin_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x7e,0x00,0x00,0x00]

v_sin_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x7f,0x00,0x00,0x00]

v_sin_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x80,0x00,0x00,0x00]

v_sin_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0xc1,0x00,0x00,0x00]

v_sin_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0xf0,0x00,0x00,0x00]

v_sin_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0xf7,0x00,0x00,0x00]

v_sin_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xe0,0xd5,0x01,0x01,0x00,0x20]

v_sin_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sin_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sin_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_sin_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_sin_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_sin_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_sin_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_sin_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_sin_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_sin_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sin_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sin_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc0,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sin_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sin_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sin_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sin_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sin_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sin_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sin_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sin_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_sin_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_sin_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_sin_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cos_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xc3,0x0a,0x7e]

v_cos_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xc3,0xfe,0x7f]

v_cos_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xc3,0x0a,0x7e]

v_cos_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xc2,0x0a,0x7e]

v_cos_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xc2,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cos_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xc2,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cos_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0xff,0x01,0x00,0x00]

v_cos_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x01,0x00,0x00,0x00]

v_cos_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x65,0x00,0x00,0x00]

v_cos_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x6a,0x00,0x00,0x00]

v_cos_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x6b,0x00,0x00,0x00]

v_cos_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x7c,0x00,0x00,0x00]

v_cos_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x7e,0x00,0x00,0x00]

v_cos_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x7f,0x00,0x00,0x00]

v_cos_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x80,0x00,0x00,0x00]

v_cos_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0xc1,0x00,0x00,0x00]

v_cos_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0xf0,0x00,0x00,0x00]

v_cos_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0xf7,0x00,0x00,0x00]

v_cos_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xe1,0xd5,0x01,0x01,0x00,0x20]

v_cos_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cos_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cos_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cos_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cos_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cos_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cos_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cos_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cos_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cos_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cos_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cos_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc2,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cos_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cos_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cos_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cos_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cos_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cos_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cos_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cos_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cos_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cos_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cos_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_norm_i16_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xc7,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xc7,0xfe,0x7f]

v_cvt_norm_i16_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xc7,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xc6,0x0a,0x7e]

v_cvt_norm_i16_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xc6,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_norm_i16_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xc6,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0xff,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x01,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x65,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x80,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xe3,0xd5,0x01,0x01,0x00,0x20]

v_cvt_norm_i16_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_norm_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_norm_i16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_norm_i16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc6,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_norm_i16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_norm_i16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_norm_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_norm_i16_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_norm_u16_f16_e32 v5, v1
// GFX10: encoding: [0x01,0xc9,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v255, v1
// GFX10: encoding: [0x01,0xc9,0xfe,0x7f]

v_cvt_norm_u16_f16_e32 v5, v255
// GFX10: encoding: [0xff,0xc9,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, s1
// GFX10: encoding: [0x01,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, s101
// GFX10: encoding: [0x65,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, m0
// GFX10: encoding: [0x7c,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, 0
// GFX10: encoding: [0x80,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, -1
// GFX10: encoding: [0xc1,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, 0.5
// GFX10: encoding: [0xf0,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, -4.0
// GFX10: encoding: [0xf7,0xc8,0x0a,0x7e]

v_cvt_norm_u16_f16_e32 v5, 0xfe0b
// GFX10: encoding: [0xff,0xc8,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_norm_u16_f16_e32 v5, 0x3456
// GFX10: encoding: [0xff,0xc8,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0xff,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x01,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x65,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x80,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xe4,0xd5,0x01,0x01,0x00,0x20]

v_cvt_norm_u16_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_norm_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_norm_u16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_norm_u16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0xc8,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_norm_u16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_norm_u16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_norm_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_norm_u16_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_swap_b32 v5, v1
// GFX10: encoding: [0x01,0xcb,0x0a,0x7e]

v_swap_b32 v255, v1
// GFX10: encoding: [0x01,0xcb,0xfe,0x7f]

v_swap_b32 v5, v255
// GFX10: encoding: [0xff,0xcb,0x0a,0x7e]

v_swaprel_b32 v5, v1
// GFX10: encoding: [0x01,0xd1,0x0a,0x7e]

v_swaprel_b32 v255, v1
// GFX10: encoding: [0x01,0xd1,0xfe,0x7f]

v_swaprel_b32 v5, v255
// GFX10: encoding: [0xff,0xd1,0x0a,0x7e]
