/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.model.Run;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.CaliperOptions;
import com.google.caliper.runner.CaliperRc;
import com.google.caliper.runner.ConsoleResultProcessor;
import com.google.caliper.runner.ConsoleWriter;
import com.google.caliper.runner.EnvironmentGetter;
import com.google.caliper.runner.FullCartesianScenarioSelection;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.OutputFileDumper;
import com.google.caliper.runner.ResultDataWriter;
import com.google.caliper.runner.ResultProcessor;
import com.google.caliper.runner.Scenario;
import com.google.caliper.runner.TrialResult;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.runner.VirtualMachine;
import com.google.caliper.runner.WebappUploader;
import com.google.caliper.util.InterleavedReader;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Util;
import com.google.caliper.worker.WorkerMain;
import com.google.caliper.worker.WorkerRequest;
import com.google.caliper.worker.WorkerResponse;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Closeables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class CaliperRun {
    private final CaliperOptions options;
    private final CaliperRc caliperRc;
    private final ConsoleWriter console;
    private final BenchmarkClass benchmarkClass;
    private final Collection<BenchmarkMethod> methods;
    private final Instrument instrument;
    private final List<ResultProcessor> resultProcessors;

    public CaliperRun(CaliperOptions options, CaliperRc caliperRc, ConsoleWriter console) throws InvalidCommandException, InvalidBenchmarkException {
        this.options = options;
        this.caliperRc = caliperRc;
        this.console = console;
        Class<?> aClass = CaliperRun.classForName(options.benchmarkClassName());
        this.benchmarkClass = new BenchmarkClass(aClass);
        this.instrument = Instrument.createInstrument(options.instrumentName(), caliperRc);
        this.methods = CaliperRun.chooseBenchmarkMethods(this.benchmarkClass, this.instrument, options);
        this.resultProcessors = this.createResultProcessors();
        this.benchmarkClass.validateParameters(options.userParameters());
    }

    public void run() throws InvalidBenchmarkException {
        ShortDuration estimate;
        ImmutableList<VirtualMachine> vms = this.createVms((Set<String>)this.options.vmNames());
        ImmutableSetMultimap<String, String> combinedParams = this.benchmarkClass.userParameters().fillInDefaultsFor(this.options.userParameters());
        ImmutableSetMultimap<String, String> vmArguments = this.benchmarkClass.injectableVmArguments().fillInDefaultsFor(this.options.vmArguments());
        FullCartesianScenarioSelection selection = new FullCartesianScenarioSelection(this.methods, (Collection<VirtualMachine>)vms, (SetMultimap<String, String>)combinedParams, (SetMultimap<String, String>)vmArguments);
        this.console.describe(selection);
        ImmutableSet<Scenario> allScenarios = selection.buildScenarios();
        this.console.beforeDryRun(allScenarios.size());
        this.console.flush();
        ImmutableSet<Scenario> scenariosToRun = this.dryRun((Set<Scenario>)allScenarios);
        if (scenariosToRun.size() != allScenarios.size()) {
            this.console.skippedScenarios(allScenarios.size() - scenariosToRun.size());
        }
        try {
            ShortDuration perTrial = this.instrument.estimateRuntimePerTrial();
            estimate = perTrial.times(scenariosToRun.size() * this.options.trialsPerScenario());
        }
        catch (Exception e) {
            estimate = ShortDuration.zero();
        }
        this.console.beforeRun(this.options.trialsPerScenario(), scenariosToRun.size(), estimate);
        this.console.flush();
        if (this.options.dryRun()) {
            return;
        }
        ResultDataWriter results = new ResultDataWriter();
        results.writeInstrument(this.instrument);
        results.writeEnvironment(new EnvironmentGetter().getEnvironmentSnapshot());
        int scenariosExecuted = 0;
        int totalTrials = scenariosToRun.size() * this.options.trialsPerScenario();
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.options.trialsPerScenario(); ++i) {
            for (Scenario scenario : scenariosToRun) {
                TrialResult trialResult = this.measure(scenario);
                results.writeTrialResult(trialResult);
                this.console.print(String.format("\r%d of %d measurements complete: %.1f%%.", ++scenariosExecuted, totalTrials, (double)scenariosExecuted * 100.0 / (double)totalTrials));
            }
        }
        this.console.print("\n");
        long elapsed = System.currentTimeMillis() - start;
        this.console.afterRun(ShortDuration.of(elapsed, TimeUnit.MILLISECONDS));
        Run run = results.getRun();
        run.label = this.methods.iterator().next().toString();
        if (this.caliperRc.getProperty("results.charts.boolean").equals("true")) {
            ResultProcessor resultProcessor = null;
            String resultProcessorName = this.caliperRc.getProperty("results.charts.class");
            try {
                Class<?> someClass = Util.lenientClassForName(resultProcessorName);
                Class<ResultProcessor> resultProcessorClass = someClass.asSubclass(ResultProcessor.class);
                Constructor<ResultProcessor> resultProcessorConstr = resultProcessorClass.getDeclaredConstructor(new Class[0]);
                resultProcessorConstr.setAccessible(true);
                resultProcessor = resultProcessorConstr.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resultProcessor.handleResults(run);
        }
        for (ResultProcessor resultProcessor : this.resultProcessors) {
            resultProcessor.handleResults(run);
        }
    }

    private ImmutableList<VirtualMachine> createVms(Set<String> vmNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (vmNames.isEmpty()) {
            builder.add((Object)VirtualMachine.hostVm());
        } else {
            for (String vmName : vmNames) {
                builder.add((Object)this.findVm(vmName));
            }
        }
        return builder.build();
    }

    private VirtualMachine findVm(String vmName) {
        String home = (String)Objects.firstNonNull((Object)this.caliperRc.homeDirForVm(vmName), (Object)vmName);
        String absoluteHome = new File(home).isAbsolute() ? home : this.caliperRc.vmBaseDirectory() + "/" + home;
        List<String> verboseModeArgs = this.caliperRc.verboseArgsForVm(vmName);
        return VirtualMachine.from(vmName, absoluteHome, this.caliperRc.vmArgsForVm(vmName), verboseModeArgs);
    }

    private TrialResult measure(Scenario scenario) {
        WorkerRequest request = new WorkerRequest(this.instrument.workerOptions(), this.instrument.workerClass().getName(), this.benchmarkClass.name(), scenario.benchmarkMethod().name(), (Map<String, String>)scenario.userParameters(), (Map<String, String>)scenario.vmArguments());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).redirectErrorStream(true);
        List<String> args = processBuilder.command();
        String jdkPath = scenario.vm().execPath.getAbsolutePath();
        args.add(jdkPath);
        args.addAll((Collection<String>)scenario.vmArguments().values());
        Collections.addAll(args, "-cp", System.getProperty("java.class.path"));
        if (this.options.detailedLogging()) {
            args.addAll((Collection<String>)scenario.vm().verboseModeArgs);
        }
        Iterables.addAll(args, this.instrument.getExtraCommandLineArgs());
        args.add(WorkerMain.class.getName());
        args.add(request.toString());
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        ArrayList eventLog = Lists.newArrayList();
        InputStreamReader in = null;
        WorkerResponse response = null;
        try {
            Object o;
            in = new InputStreamReader(process.getInputStream(), Charsets.UTF_8);
            InterleavedReader reader = new InterleavedReader(in);
            while ((o = reader.read()) != null) {
                if (o instanceof String) {
                    eventLog.add((String)o);
                    continue;
                }
                JsonObject jsonObject = (JsonObject)o;
                response = (WorkerResponse)Util.GSON.fromJson((JsonElement)jsonObject, WorkerResponse.class);
            }
        }
        catch (IOException e) {
            try {
                throw new AssertionError((Object)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                process.destroy();
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        process.destroy();
        if (response == null) {
            for (String event : eventLog) {
                System.out.println(event);
            }
            throw new RuntimeException("Got no response!");
        }
        return new TrialResult(scenario, response.measurements, eventLog, args);
    }

    private static Collection<BenchmarkMethod> chooseBenchmarkMethods(BenchmarkClass benchmarkClass, Instrument instrument, CaliperOptions options) throws InvalidBenchmarkException {
        ImmutableSortedMap<String, BenchmarkMethod> methodMap = benchmarkClass.findAllBenchmarkMethods(instrument);
        ImmutableSet<String> names = options.benchmarkMethodNames();
        return names.isEmpty() ? methodMap.values() : Maps.filterKeys(methodMap, (Predicate)Predicates.in(names)).values();
    }

    private List<ResultProcessor> createResultProcessors() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new ConsoleResultProcessor(this.options.calculateAggregateScore()));
        builder.add((Object)new OutputFileDumper(this.options.outputFileOrDir(), this.benchmarkClass.name()));
        builder.add((Object)WebappUploader.create(this.benchmarkClass.name(), this.caliperRc));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableSet<Scenario> dryRun(Set<Scenario> scenarios) throws UserCodeException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Scenario scenario : scenarios) {
            try {
                Benchmark benchmark = this.benchmarkClass.createAndStage(scenario);
                try {
                    this.instrument.dryRun(benchmark, scenario.benchmarkMethod());
                    builder.add((Object)scenario);
                }
                finally {
                    this.benchmarkClass.cleanup(benchmark);
                }
            }
            catch (SkipThisScenarioException innocuous) {}
        }
        return builder.build();
    }

    private static Class<?> classForName(String className) throws InvalidCommandException, InvalidBenchmarkException {
        try {
            return Util.lenientClassForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidCommandException("Benchmark class not found: " + className, new Object[0]);
        }
        catch (ExceptionInInitializerError e) {
            throw new UserCodeException("Exception thrown while initializing class '" + className + "'", e.getCause());
        }
    }
}

