


RFL(1)                                                     RFL(1)


NNAAMMEE
       rfl - add messages to a storage digest

SSYYNNOOPPSSIISS
       rfl  [+dest-folder]  [msgs]  [-add  component [-add compo-
            nent...]]  [-inplace] [-noinplace] [-keep]  [-nokeep]
            [-query]  [-noquery]  [[-range  msgs]  OR  [-to msg]]
            [-src +src-folder] [-verbose] [-noverbose] [-help]

DDEESSCCRRIIPPTTIIOONN
       _r_f_l is a Perl script.  It reads the  message(s)  (default:
       current  message)  named on the command line from the cur-
       rent folder (or  another  folder,  if  you  name  it  with
       `-src').   _r_f_l  appends the message(s) to the last message
       with the same `Subject:' in the destination  folder.   The
       destination message will be changed into an RFC934-compat-
       ible digest format (if it isn't already) that you can feed
       to  _b_u_r_s_t(1) to get the individual messages back.  You can
       add more messages to the digest by  using  _r_f_l  again.   A
       special  `X-mhglue:' field is added to mark the digest; if
       you delete this field, _r_f_l won't recognize the digest.

       For example, this command:
              rfl 23 24 +foobar
       would read message 23 from the current  folder,  find  the
       last  message  with  the  same `Subject:' in the `+foobar'
       folder, and add it to the end.  Then, it will do the  same
       thing  for  message  24  (find  message with same subject,
       append message 24 to it).

       _r_f_l will edit the destination message  in  place,  so  any
       links  to it won't be broken.  If you use the `-noinplace'
       switch, _r_f_l will create a new message from a copy  of  the
       destination message.

       _r_f_l  always  tells  you  which  message  is being added to
       which.  The `-verbose' switch makes _r_f_l tell you more.

       The `-query' switch shows you a _s_c_a_n(1) list  of  messages
       in  the  destination  folder  and asks which one to append
       each message to.

       The program searches the destination  folder  starting  at
       the  last  (highest-numbered)  message.   By  default, _r_f_l
       checks the last 998 messages in  the  destination  folder.
       If  the  folder  has  a  lot  of messages, that can take a
       while.  So, if you use the `-range' switch (typically,  in
       your  MH  profile),  _r_f_l will only search those particular
       messages.  For example:
              rfl @sub -range last:20
       would check the last 20 messages in the  `@sub'  subfolder
       and add the current message from the current folder to the
       last     message that matches.  To give a  range  of  spe-
       cific  numbers, quote the argument (so the shell will pass



                              [mh.6]                            1





RFL(1)                                                     RFL(1)


       all of it as one argument).  For  instance,  to  make  _r_f_l
       search the previous 50 and next 50 messages:
              rfl -range "prev:50 next:50" ...
       If  _r_f_l  can't  find  a  matching  message (unless you use
       -query, of course), it skips the  message  and  tries  the
       next one (if any).

       You  can  also use `-to msg' to specify the exact destina-
       tion message (no subject searching).  This  is  handy  for
       adding  other  messages  to the current message (`cur') or
       when you know the exact message number (like `last').  For
       example,  to  add  the  last  2  messages from the current
       folder to the last message in `+reports':
              rfl -to last +reports last:2
       To add messages 1 and 5 from `+junk' to the  current  mes-
       sage in the current folder, type:
              rfl 1 5 -src +junk -to cur

       By default, _r_f_l copies all message headers into the digest
       body.  If you have a file  named  `rfl.skiphdrs'  in  your
       top-level  mail  directory,  _r_f_l  will not copy the fields
       listed there.  List the fields to skip, one per  line,  in
       the file.  You can also use _p_e_r_l-type (basically, _e_d-type)
       regular expressions in the file.  For  instance,  to  omit
       `Received:',  `Sender:',  and  any  `X-' fields, use these
       three lines (not indented):
              received
              sender
              x-.*

       By default, _r_f_l copies the `From:', `To:', and  `Subject:'
       fields  to  the  header  of  the  digest.  (It also adds a
       `Date:' field with the time the digest was  edited.)   The
       `-add'  switch names other fields to add.  For example, to
       add `Message-ID:' and `cc:' fields, use:
              rfl -add message-id -add cc ...
       Note: the same `-add' switches must be used every time you
       append  more messages to the digest.  Otherwise, the extra
       fields you `-add'ed before won't  be  copied  to  the  new
       digest.

       By default, _r_f_l uses _r_m_m(1) on the source message(s) after
       copying.  If you use the `-keep'  switch,  _r_f_l  won't  use
       _r_m_m.

       You  can  put  an  `rfl:'  field  in  your MH profile with
       default switches you want (like `-verbose').  And, as with
       most  MH  commands, you can make _r_f_l versions (links) with
       other names.  For  example,  to  simulate  the  old  _m_h_a_d_d
       script I used to have that adds other messages to the cur-
       rent message, I made a symbolic link named _m_h_a_d_d  pointing
       to _r_f_l.  Then I put this line in my MH profile:
              mhadd: -to cur
       Then I can use:



                              [mh.6]                            2





RFL(1)                                                     RFL(1)


              mhadd 23
       to  add  message  23  to  the current message.  (Note: the
       _r_f_l_._s_k_i_p_h_d_r_s file won't be used when you  call  _r_f_l  by  a
       different  name.   This is a feature.  Create another file
       -- here, for example, _m_h_a_d_d_._s_k_i_p_h_d_r_s -- or just  link  the
       other file to your original _r_f_l_._s_k_i_p_h_d_r_s.

DDIISSCCLLAAIIMMEERR ((SSIIGGHH))
       USE  THIS  CODE AT YOUR OWN RISK.  THE AUTHOR(S) CANNOT BE
       RESPONSIBLE FOR ANY PROBLEMS YOU HAVE WITH THE  SCRIPT  OR
       LIABLE  FOR  ANY DAMAGES THAT THIS SCRIPT CAUSES, DIRECTLY
       OR INDIRECTLY.  THE USER IS ASSUMED TO UNDERSTAND  MH  AND
       PERL  WELL  ENOUGH TO DECIDE WHETHER OR NOT THIS SCRIPT IS
       SUITABLE AND WILL WORK CORRECTLY.  ETC. ETC.

       This program is in the public domain.  If you  modify  it,
       please  add  comments to the code that mark your revisions
       clearly (so people will know that it  isn't  the  original
       _r_f_l).   Please also send me a copy of any changes you make
       so that I can think about folding them into a new release.

FFIILLEESS
       $MH or $HOME/.mh_profile      The user profile
       <mh-dir>/<prog>.skiphdrs      Header fields not to copy

PPRROOFFIILLEE CCOOMMPPOONNEENNTTSS
       Path:                 To determine the user's MH directory
       Current-Folder:       To find the default current folder

SSEEEE AALLSSOO
       _P_r_o_p_o_s_e_d _S_t_a_n_d_a_r_d _f_o_r _M_e_s_s_a_g_e _E_n_c_a_p_s_u_l_a_t_i_o_n (aka RFC-934),
       _p_e_r_l(1), _r_e_f_i_l_e(1), _b_u_r_s_t(1), _s_c_a_n(1), _r_m_m(1), _m_h_-_m_a_i_l(5).

CCOONNTTEEXXTT
       If `-src +folder' is given, it  will  become  the  current
       folder.

BBUUGGSS
       _m_h_p_a_t_h(1)  refuses  to  handle  folders with more than 998
       messages, so _r_f_l can't use a destination `-range' of  more
       than 998 messages.

       _r_f_l can't add an _r_f_l digest to another _r_f_l digest and keep
       the same digest format.

       With a command like `rfl 19 20', you can accidentally  add
       the  first message (19) to the second message (20) if they
       both have the same subject.  Then the second message can't
       be   added   to  anything  because  it's  an  _r_f_l  digest.
       Workaround (until _r_f_l can add  digests  to  digests):  use
       `-range "1-18 21-last"'.

       _r_f_l does lots of work to make the digest header have `Sub-
       ject:' fields without newlines or multiple spaces.  That's



                              [mh.6]                            3





RFL(1)                                                     RFL(1)


       because  _r_e_p_l(1)  formats  the  subjects  of  messages  it
       replies to in the same way.

       _r_f_l checks pathnames to be sure a message isn't  added  to
       itself.   But  that doesn't stop _r_f_l from adding a message
       to the message's own _l_i_n_k.

       Some coding is kind of ugly or inefficient.  (This  is  my
       first Perl script.)

       Prints informative messages without the `-verbose' switch.
       This is actually a feature...

AAUUTTHHOORR
       Jerry Peek.  I can't promise to support the  program,  but
       please  report  bugs to me, jpeek@jpeek.com... I'll fix them
       as soon as possible, with thanks.   Suggestions  are  wel-
       come, too!







































                              [mh.6]                            4


